/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.builder;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JWTUtil.class);

    private JWTUtil() {
    }

    public static String getJWTToken(String jwtKey, String privateKeyString, String userName, int expiresIn, String locale) {
        String msg;
        PrivateKey privateKey = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            byte[] content = privateKeyString.getBytes();
            String pkcs8Pem = new String(content, StandardCharsets.UTF_8);
            byte[] pkcs8EncodedBytes = Base64.decodeBase64((String)pkcs8Pem);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(pkcs8EncodedBytes);
            privateKey = factory.generatePrivate(privKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            msg = String.format("Error while generating JWT token (NoSuchAlgorithmException) : %s", e.getMessage());
            LOGGER.error(msg);
        }
        catch (InvalidKeySpecException e) {
            msg = String.format("Error while generating JWT token (Private Key - InvalidKeySpecException) : %s", e.getMessage());
            LOGGER.error(msg);
        }
        Algorithm algo = Algorithm.RSA512(null, (RSAPrivateKey)((RSAPrivateKey)privateKey));
        Long expiryTime = System.currentTimeMillis() + (long)(expiresIn * 1000);
        Date today = new Date();
        return JWT.create().withIssuer(jwtKey).withClaim("iat", today).withClaim("exp", new Date(expiryTime)).withSubject(userName).withClaim("locale", locale).sign(algo);
    }
}

