/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.builder;

import com.yodlee.sdk.api.UserApi;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.builder.Builder;
import com.yodlee.sdk.builder.CobrandContextBuilder;
import com.yodlee.sdk.builder.ConfigValidationUtil;
import com.yodlee.sdk.builder.ContextBuilderFactory;
import com.yodlee.sdk.configuration.cobrand.CobrandConfiguration;
import com.yodlee.sdk.configuration.user.UserConfiguration;
import com.yodlee.sdk.context.CobrandContext;
import com.yodlee.sdk.context.UserContext;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContextBuilder
implements Builder<UserConfiguration, UserContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserContextBuilder.class);
    private static Map<String, CobrandContext> cobrandMap = new HashMap<String, CobrandContext>();

    @Override
    public UserContext build(UserConfiguration userConfiguration) throws ApiException {
        ConfigValidationUtil.validateConfig(userConfiguration);
        Boolean expiredContext = false;
        String clientName = userConfiguration.getName();
        CobrandContext cobrandContext = cobrandMap.get(clientName);
        if (cobrandContext == null) {
            cobrandContext = this.doCobLogin(userConfiguration);
        }
        try {
            return this.doSamlLogin(userConfiguration, cobrandContext);
        }
        catch (ApiException e) {
            if (!e.getResponseBody().contains("Y008")) {
                throw e;
            }
            LOGGER.info("cobSession is expired");
            expiredContext = true;
            if (expiredContext.booleanValue()) {
                LOGGER.info("cobSession is expired, hence recreating the session");
                cobrandContext = this.doCobLogin(userConfiguration);
                return this.doSamlLogin(userConfiguration, cobrandContext);
            }
            return null;
        }
    }

    private UserContext doSamlLogin(UserConfiguration userConfiguration, CobrandContext cobrandContext) throws ApiException {
        UserApi userApi = new UserApi(cobrandContext, userConfiguration);
        userApi.samlLogin(userConfiguration.getSamlResponse(), userConfiguration.getIssuer(), userConfiguration.getSource());
        return (UserContext)userApi.getContext();
    }

    private CobrandContext doCobLogin(UserConfiguration userConfiguration) throws ApiException {
        CobrandConfiguration cobrandConfiguration = new CobrandConfiguration();
        cobrandConfiguration.setBasePath(userConfiguration.getBasePath());
        cobrandConfiguration.setApiVersion(userConfiguration.getApiVersion());
        cobrandConfiguration.setName(userConfiguration.getName());
        cobrandConfiguration.setLocale(userConfiguration.getLocale());
        cobrandConfiguration.setLoginName(userConfiguration.getLoginName());
        cobrandConfiguration.setPassword(userConfiguration.getPassword());
        ConfigValidationUtil.validateConfig(cobrandConfiguration);
        CobrandContextBuilder cobrandContextBuilder = ContextBuilderFactory.createCobrandContextBuilder();
        CobrandContext cobrandContext = cobrandContextBuilder.build(cobrandConfiguration);
        cobrandMap.put(cobrandConfiguration.getName(), cobrandContext);
        return cobrandContext;
    }
}

