/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yodlee.api.model.AbstractModelComponent;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.api.util.ApiUtils;
import com.yodlee.sdk.client.ApiCallback;
import com.yodlee.sdk.client.ApiContext;
import com.yodlee.sdk.client.ApiResponse;
import com.yodlee.sdk.client.Pair;
import com.yodlee.sdk.client.ProgressRequestBody;
import com.yodlee.sdk.client.RenewTokenHandler;
import com.yodlee.sdk.client.StringUtil;
import com.yodlee.sdk.client.util.OkHttpUtil;
import com.yodlee.sdk.configuration.AbstractConfiguration;
import com.yodlee.sdk.configuration.cobrand.AbstractBaseConfiguration;
import com.yodlee.sdk.context.Context;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class ApiClient {
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_IDLE_CONNECTION = 30;
    private static final Integer DEFAULT_CONNECTION_KEEP_ALIVE_DURATION = 30000;
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiClient.class);
    private String basePath = null;
    private boolean debugging = false;
    private final Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private OkHttpClient httpClient;
    private HttpLoggingInterceptor loggingInterceptor;
    private final ObjectMapper mapper = new ObjectMapper();
    private Context<?> context;
    private OkHttpClient.Builder httpBuilder;

    public ApiClient() {
        this((AbstractConfiguration)null);
    }

    public ApiClient(Context<?> context) {
        this(context != null ? (AbstractConfiguration)context.getConfiguration() : null);
    }

    public ApiClient(AbstractConfiguration configuration) {
        this(configuration == null ? 10000 : ApiClient.getSocketTimeOutFromConfig(configuration), configuration == null ? 10000 : ApiClient.getReadTimeOutFromConfig(configuration), configuration == null ? 10000 : ApiClient.getWriteTimeOutFromConfig(configuration), configuration == null ? 30 : ApiClient.getMaxIdleConnectionFromConfig(configuration), configuration == null ? DEFAULT_CONNECTION_KEEP_ALIVE_DURATION : ApiClient.getConnectionKeepAliveDurationFromConfig(configuration));
    }

    public ApiClient(int socketTimeOut, int readTimeOut, int writeTimeOut, int maxIdleConnection, int connectionKeepAliveDuration) {
        this.httpClient = OkHttpUtil.OKHTTP_INSTANCE.getOkHttpClient(socketTimeOut, readTimeOut, writeTimeOut, maxIdleConnection, connectionKeepAliveDuration);
        this.httpBuilder = OkHttpUtil.OKHTTP_INSTANCE.getOkHttpBuilder();
        this.setUserAgent("JavaSDK1.0.23");
    }

    private static int getSocketTimeOutFromConfig(AbstractConfiguration configuration) {
        if (configuration instanceof AbstractBaseConfiguration) {
            AbstractBaseConfiguration config = (AbstractBaseConfiguration)configuration;
            Integer socketTimeout = config.getSocketTimeout();
            return socketTimeout == null ? 10000 : socketTimeout;
        }
        return 10000;
    }

    private static int getReadTimeOutFromConfig(AbstractConfiguration configuration) {
        if (configuration instanceof AbstractBaseConfiguration) {
            AbstractBaseConfiguration config = (AbstractBaseConfiguration)configuration;
            Integer readTimeout = config.getReadTimeout();
            return readTimeout == null ? 10000 : readTimeout;
        }
        return 10000;
    }

    private static int getWriteTimeOutFromConfig(AbstractConfiguration configuration) {
        if (configuration instanceof AbstractBaseConfiguration) {
            AbstractBaseConfiguration config = (AbstractBaseConfiguration)configuration;
            Integer writeTimeout = config.getWriteTimeout();
            return writeTimeout == null ? 10000 : writeTimeout;
        }
        return 10000;
    }

    private static int getMaxIdleConnectionFromConfig(AbstractConfiguration configuration) {
        if (configuration instanceof AbstractBaseConfiguration) {
            AbstractBaseConfiguration config = (AbstractBaseConfiguration)configuration;
            Integer maxIdleConnection = config.getMaxIdleConnection();
            return maxIdleConnection == null ? 30 : maxIdleConnection;
        }
        return 30;
    }

    private static int getConnectionKeepAliveDurationFromConfig(AbstractConfiguration configuration) {
        if (configuration instanceof AbstractBaseConfiguration) {
            AbstractBaseConfiguration config = (AbstractBaseConfiguration)configuration;
            Integer keepAliveDuration = config.getWriteTimeout();
            return keepAliveDuration == null ? DEFAULT_CONNECTION_KEEP_ALIVE_DURATION : keepAliveDuration;
        }
        return DEFAULT_CONNECTION_KEEP_ALIVE_DURATION;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addHeader("User-Agent", userAgent);
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public void addHeader(String headerKey, String value) {
        this.defaultHeaderMap.put(headerKey, value);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                this.httpClient.interceptors().add(this.loggingInterceptor);
            } else {
                this.httpClient.interceptors().remove(this.loggingInterceptor);
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient = this.httpBuilder.connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.connectTimeoutMillis();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.httpClient = this.httpBuilder.readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.readTimeoutMillis();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.httpClient = this.httpBuilder.writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.writeTimeoutMillis();
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = "";
            try {
                jsonStr = this.mapper.writeValueAsString(param);
            }
            catch (JsonProcessingException e) {
                String msg = String.format("Exception occurred. %s", e.getMessage());
                LOGGER.error(msg, (Throwable)e);
            }
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection<?> value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return APPLICATION_JSON;
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public <T extends AbstractModelComponent> ApiResponse<T> execute(Call call, Class<T> returnType) throws ApiException {
        try {
            RenewTokenHandler.checkAndRenewToken(this.context);
            Response response = call.execute();
            T data = this.handleResponse(response, returnType);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            this.logException(e);
            throw new ApiException(e);
        }
    }

    public <T extends AbstractModelComponent> void executeAsync(Call call, ApiCallback<T> callback) throws ApiException {
        this.executeAsync(call, null, callback);
    }

    public <T extends AbstractModelComponent> void executeAsync(Call call, final Class<T> returnType, final ApiCallback<T> callback) throws ApiException {
        if (callback == null) {
            throw new ApiException(ApiUtils.getErrorMessage("callback.required", new Object[0]));
        }
        RenewTokenHandler.checkAndRenewToken(this.context);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Call call, Response response) throws IOException {
                Object result;
                try {
                    result = ApiClient.this.handleResponse(response, returnType);
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T extends AbstractModelComponent> T handleResponse(Response response, Class<T> returnType) throws ApiException {
        if (response.isSuccessful()) {
            return this.processSuccessResponse(response, returnType);
        }
        throw this.processFailureResponse(response);
    }

    private <T extends AbstractModelComponent> T processSuccessResponse(Response response, Class<T> returnType) throws ApiException {
        if (returnType == null || response.code() == 204) {
            if (response.body() != null) {
                response.body().close();
            }
            return null;
        }
        return this.deserialize(response, returnType);
    }

    private ApiException processFailureResponse(Response response) {
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                this.logException(e);
                return new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        return new ApiException(response.message(), response.code(), response.headers().toMultimap(), respBody);
    }

    public <T extends AbstractModelComponent> T deserialize(Response response, Class<T> returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = APPLICATION_JSON;
        }
        if (this.isJsonMime(contentType)) {
            try {
                return (T)((AbstractModelComponent)this.mapper.readValue(respBody, returnType));
            }
            catch (IOException e) {
                throw new ApiException(e.getMessage());
            }
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), response.headers().toMultimap(), respBody);
    }

    private void logException(Exception e) {
        String msg = String.format("Exception occurred. %s", e.getMessage());
        LOGGER.error(msg, (Throwable)e);
    }

    public Call buildCall(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Request request = this.buildRequest(path, method, queryParams, collectionQueryParams, body, headerParams, formParams, authNames, progressRequestListener);
        return this.httpClient.newCall(request);
    }

    public Call buildCall(ApiContext apiContext, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Request request = this.buildRequest(apiContext.getPath(), apiContext.getHttpMethod().name(), apiContext.getQueryParams(), apiContext.getCollectionQueryParams(), apiContext.getBody(), apiContext.getHeaderParams(), apiContext.getFormParams(), apiContext.getAuthNames(), progressRequestListener);
        return this.httpClient.newCall(request);
    }

    public Request buildRequest(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String url = this.buildUrl(path, queryParams, collectionQueryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, reqBuilder);
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            contentType = APPLICATION_JSON;
        }
        Object reqBody = !HttpMethod.permitsRequestBody((String)method) ? null : ("application/x-www-form-urlencoded".equals(contentType) ? this.buildRequestBodyFormEncoding(formParams) : ("multipart/form-data".equals(contentType) ? this.buildRequestBodyMultipart(formParams) : (body == null ? ("DELETE".equals(method) ? null : RequestBody.create((String)"", (MediaType)MediaType.parse((String)contentType))) : this.serialize(body, contentType))));
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody((RequestBody)reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return request;
    }

    public String buildUrl(String path, List<Pair> queryParams, List<Pair> collectionQueryParams) {
        StringBuilder url = new StringBuilder();
        url.append(this.basePath).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            url.append((CharSequence)this.processQueryParams(path, queryParams));
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            this.processCollectionQueryParams(collectionQueryParams, url);
        }
        return url.toString();
    }

    private void processCollectionQueryParams(List<Pair> collectionQueryParams, StringBuilder url) {
        String prefix = url.toString().contains("?") ? "&" : "?";
        for (Pair param : collectionQueryParams) {
            if (param.getValue() == null) continue;
            if (prefix != null) {
                url.append(prefix);
                prefix = null;
            } else {
                url.append("&");
            }
            String value = this.parameterToString(param.getValue());
            url.append(this.escapeString(param.getName())).append("=").append(value);
        }
    }

    private StringBuilder processQueryParams(String path, List<Pair> queryParams) {
        StringBuilder url = new StringBuilder();
        String prefix = path.contains("?") ? "&" : "?";
        for (Pair param : queryParams) {
            if (param.getValue() == null) continue;
            if (prefix != null) {
                url.append(prefix);
                prefix = null;
            } else {
                url.append("&");
            }
            String value = this.parameterToString(param.getValue());
            url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
        }
        return url;
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBodyBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBodyBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBody.Builder multiPartBuilder = new MultipartBody.Builder();
        multiPartBuilder.setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                File file = (File)param.getValue();
                Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + file.getName() + "\""});
                MediaType mediaType = MediaType.parse((String)this.guessContentTypeFromFile(file));
                multiPartBuilder.addPart(partHeaders, RequestBody.create((File)file, (MediaType)mediaType));
                continue;
            }
            Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
            multiPartBuilder.addPart(partHeaders, RequestBody.create((String)this.parameterToString(param.getValue()), null));
        }
        return multiPartBuilder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((byte[])((byte[])obj), (MediaType)MediaType.parse((String)contentType));
        }
        if (obj instanceof File) {
            return RequestBody.create((File)((File)obj), (MediaType)MediaType.parse((String)contentType));
        }
        if (this.isJsonMime(contentType)) {
            String content;
            if (obj != null) {
                try {
                    content = this.mapper.writeValueAsString(obj);
                }
                catch (JsonProcessingException e) {
                    content = "{}";
                }
            } else {
                content = "{}";
            }
            return RequestBody.create((String)content, (MediaType)MediaType.parse((String)contentType));
        }
        String msg = String.format("Content type %s is not supported", contentType);
        throw new ApiException(Collections.emptyList(), msg, false);
    }

    public void registerNetworkInterceptor(Interceptor interceptor) {
        if (this.shouldRegisterNetworkInterceptor()) {
            this.httpClient = this.httpBuilder.addNetworkInterceptor(interceptor).build();
        }
    }

    public boolean shouldRegisterNetworkInterceptor() {
        return this.httpBuilder != null && this.httpBuilder.getNetworkInterceptors$okhttp() != null && this.httpBuilder.getNetworkInterceptors$okhttp().isEmpty();
    }
}

