/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.client;

import com.yodlee.sdk.client.HttpMethod;
import com.yodlee.sdk.client.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiContext {
    private String path;
    private HttpMethod httpMethod;
    private final List<Pair> queryParams;
    private final List<Pair> collectionQueryParams;
    private final Object body;
    private final Map<String, String> headerParams;
    private final Map<String, Object> formParams;
    private String[] authNames;

    public ApiContext(String path, HttpMethod httpMethod, Object body) {
        this.path = path;
        this.httpMethod = httpMethod;
        this.body = body;
        this.queryParams = new ArrayList<Pair>();
        this.collectionQueryParams = new ArrayList<Pair>();
        this.headerParams = new HashMap<String, String>();
        this.formParams = new HashMap<String, Object>();
        this.headerParams.put("Accept", "application/json");
        this.headerParams.put("Content-Type", "application/json");
    }

    public String getPath() {
        return this.path;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public List<Pair> getQueryParams() {
        return Collections.unmodifiableList(this.queryParams);
    }

    public void addQueryParam(Pair queryParam) {
        this.queryParams.add(queryParam);
    }

    public void removeQueryParam(Pair queryParam) {
        this.queryParams.remove(queryParam);
    }

    public void clearQueryParams() {
        this.queryParams.clear();
    }

    public List<Pair> getCollectionQueryParams() {
        return Collections.unmodifiableList(this.collectionQueryParams);
    }

    public Object getBody() {
        return this.body;
    }

    public Map<String, String> getHeaderParams() {
        return Collections.unmodifiableMap(this.headerParams);
    }

    public String addHeaderParam(String key, String value) {
        return this.headerParams.put(key, value);
    }

    public String removeHeaderParam(String key) {
        return this.headerParams.remove(key);
    }

    public void clearHeaderParams() {
        this.headerParams.clear();
    }

    public Map<String, Object> getFormParams() {
        return Collections.unmodifiableMap(this.formParams);
    }

    public Object addFormParam(String key, Object value) {
        return this.formParams.put(key, value);
    }

    public Object removeFormParam(String key) {
        return this.formParams.remove(key);
    }

    public void clearFormParams() {
        this.formParams.clear();
    }

    public String[] getAuthNames() {
        return this.authNames;
    }
}

