/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.client;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.yodlee.sdk.api.exception.ApiException;
import com.yodlee.sdk.builder.ClientCredentialAdminContextBuilder;
import com.yodlee.sdk.builder.ClientCredentialUserContextBuilder;
import com.yodlee.sdk.builder.ContextBuilderFactory;
import com.yodlee.sdk.builder.JWTAppContextBuilder;
import com.yodlee.sdk.builder.JWTUserContextBuilder;
import com.yodlee.sdk.configuration.cobrand.ClientCredentialAdminConfiguration;
import com.yodlee.sdk.configuration.cobrand.JWTAppConfiguration;
import com.yodlee.sdk.configuration.user.ClientCredentialUserConfiguration;
import com.yodlee.sdk.configuration.user.JWTUserConfiguration;
import com.yodlee.sdk.context.AbstractClientCredentialContext;
import com.yodlee.sdk.context.AbstractJWTContext;
import com.yodlee.sdk.context.ClientCredentialAdminContext;
import com.yodlee.sdk.context.ClientCredentialUserContext;
import com.yodlee.sdk.context.Context;
import com.yodlee.sdk.context.JWTAppContext;
import com.yodlee.sdk.context.JWTUserContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewTokenHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenewTokenHandler.class);

    private RenewTokenHandler() {
    }

    public static void checkAndRenewToken(Context<?> context) {
        try {
            if (context instanceof JWTAppContext && RenewTokenHandler.isJWTTokenExpired((JWTAppContext)context)) {
                RenewTokenHandler.handleJWTAppContextRenewal(context);
            } else if (context instanceof JWTUserContext && RenewTokenHandler.isJWTTokenExpired((JWTUserContext)context)) {
                RenewTokenHandler.handleJWTUserContextRenewal(context);
            } else if (context instanceof ClientCredentialAdminContext && RenewTokenHandler.isClientCredentialTokenExpired((ClientCredentialAdminContext)context)) {
                RenewTokenHandler.handleClientCredentialAppContextRenewal(context);
            } else if (context instanceof ClientCredentialUserContext && RenewTokenHandler.isClientCredentialTokenExpired((ClientCredentialUserContext)context)) {
                RenewTokenHandler.handleClientCredentialUserContextRenewal(context);
            }
        }
        catch (ApiException e) {
            LOGGER.error("Exception occurred while renewing token", (Throwable)e);
        }
    }

    private static boolean isJWTTokenExpired(AbstractJWTContext<?> jwtContext) {
        DecodedJWT jwtToken = JWT.decode((String)jwtContext.getJwtToken());
        return jwtToken.getExpiresAt().before(new Date());
    }

    private static void handleJWTAppContextRenewal(Context<?> context) throws ApiException {
        JWTAppContextBuilder jwtAppContextBuilder = ContextBuilderFactory.createJWTAppContextBuilder();
        JWTAppContext renewedJWTContext = jwtAppContextBuilder.build((JWTAppConfiguration)context.getConfiguration());
        JWTAppContext originalContext = (JWTAppContext)context;
        originalContext.setJwtToken(renewedJWTContext.getJwtToken());
    }

    private static void handleJWTUserContextRenewal(Context<?> context) throws ApiException {
        JWTUserContextBuilder jwtAppContextBuilder = ContextBuilderFactory.createJWTUserContextBuilder();
        JWTUserContext renewedJWTContext = jwtAppContextBuilder.build((JWTUserConfiguration)context.getConfiguration());
        JWTUserContext originalContext = (JWTUserContext)context;
        originalContext.setJwtToken(renewedJWTContext.getJwtToken());
    }

    private static void handleClientCredentialAppContextRenewal(Context<?> context) throws ApiException {
        ClientCredentialAdminContextBuilder clientCredentialAppContextBuilder = ContextBuilderFactory.createClientCredentialAdminContextBuilder();
        ClientCredentialAdminContext renewedClientCredentialContext = clientCredentialAppContextBuilder.build((ClientCredentialAdminConfiguration)context.getConfiguration());
        ClientCredentialAdminContext originalContext = (ClientCredentialAdminContext)context;
        RenewTokenHandler.updateClientCredentialContextValues(renewedClientCredentialContext, originalContext);
    }

    private static void handleClientCredentialUserContextRenewal(Context<?> context) throws ApiException {
        ClientCredentialUserContextBuilder clientCredentialAppContextBuilder = ContextBuilderFactory.createClientCredentialUserContextBuilder();
        ClientCredentialUserContext renewedClientCredentialContext = clientCredentialAppContextBuilder.build((ClientCredentialUserConfiguration)context.getConfiguration());
        ClientCredentialUserContext originalContext = (ClientCredentialUserContext)context;
        RenewTokenHandler.updateClientCredentialContextValues(renewedClientCredentialContext, originalContext);
    }

    private static void updateClientCredentialContextValues(AbstractClientCredentialContext<?> renewedClientCredentialContext, AbstractClientCredentialContext<?> originalContext) {
        originalContext.setAccessToken(renewedClientCredentialContext.getAccessToken());
        originalContext.setIssuedAt(renewedClientCredentialContext.getIssuedAt());
        originalContext.setExpiresIn(renewedClientCredentialContext.getExpiresIn());
    }

    private static boolean isClientCredentialTokenExpired(AbstractClientCredentialContext<?> clientCredentialContext) {
        Calendar currentTime = Calendar.getInstance();
        String issuedAt = clientCredentialContext.getIssuedAt();
        int expiresIn = clientCredentialContext.getExpiresIn();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date parsedDate = sdf.parse(issuedAt);
            long timeInMillis = parsedDate.getTime();
            long checkForExpiry = timeInMillis + (long)(expiresIn * 1000);
            Calendar expiryTime = Calendar.getInstance();
            expiryTime.setTimeInMillis(checkForExpiry);
            return currentTime.after(expiryTime);
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

