/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.client;

import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.RealResponseBody;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzippingInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnzippingInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        return this.unzip(response);
    }

    private Response unzip(Response response) throws IOException {
        if (response.body() == null) {
            return response;
        }
        String contentEncoding = response.headers().get("Content-Encoding");
        if (contentEncoding != null && contentEncoding.equals("gzip")) {
            LOGGER.info("Decompressing the gzip response ");
            Long contentLength = response.body().contentLength();
            GzipSource responseBody = new GzipSource((Source)response.body().source());
            Headers strippedHeaders = response.headers().newBuilder().build();
            return response.newBuilder().headers(strippedHeaders).body((ResponseBody)new RealResponseBody(response.body().contentType().toString(), contentLength.longValue(), Okio.buffer((Source)responseBody))).build();
        }
        return response;
    }
}

