/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.configuration.cobrand;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yodlee.sdk.configuration.AbstractConfiguration;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.URL;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractBaseConfiguration
extends AbstractConfiguration {
    private static final long serialVersionUID = 1L;
    @NotEmpty(message="{config.basepath.required}")
    @URL(message="{config.basepath.invalid}")
    @JsonProperty(value="basePath")
    protected String basePath;
    @NotEmpty(message="{config.apiVersion.required}")
    @JsonProperty(value="apiVersion")
    protected String apiVersion;
    @Pattern(regexp="[a-z]{2}_[A-Z]{2}", message="{config.locale.invalid}")
    @JsonProperty(value="locale")
    protected String locale;
    @Min(value=1L, message="{config.socketTimeout.min}")
    @Max(value=0x7FFFFFFFL, message="{config.socketTimeout.max}")
    @JsonProperty(value="socketTimeout")
    protected Integer socketTimeout;
    @Min(value=1L, message="{config.readTimeout.min}")
    @Max(value=0x7FFFFFFFL, message="{config.readTimeout.max}")
    @JsonProperty(value="readTimeout")
    protected Integer readTimeout;
    @Min(value=1L, message="{config.writeTimeout.min}")
    @Max(value=0x7FFFFFFFL, message="{config.writeTimeout.max}")
    @JsonProperty(value="writeTimeout")
    protected Integer writeTimeout;
    @Min(value=1L, message="{config.maxIdleConnection.min}")
    @Max(value=0x7FFFFFFFL, message="{config.maxIdleConnection.max}")
    @JsonProperty(value="maxIdleConnection")
    protected Integer maxIdleConnection;
    @Min(value=1L, message="{config.connectionKeepAliveDuration.min}")
    @Max(value=0x7FFFFFFFL, message="{config.connectionKeepAliveDuration.max}")
    @JsonProperty(value="connectionKeepAliveDuration")
    protected Integer connectionKeepAliveDuration;

    public AbstractBaseConfiguration() {
    }

    public AbstractBaseConfiguration(String basePath, String apiVersion) {
        this.basePath = basePath;
        this.apiVersion = apiVersion;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(Integer writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public Integer getMaxIdleConnection() {
        return this.maxIdleConnection;
    }

    public void setMaxIdleConnection(Integer maxIdleConnection) {
        this.maxIdleConnection = maxIdleConnection;
    }

    public Integer getConnectionKeepAliveDuration() {
        return this.connectionKeepAliveDuration;
    }

    public void setConnectionKeepAliveDuration(Integer connectionKeepAliveDuration) {
        this.connectionKeepAliveDuration = connectionKeepAliveDuration;
    }
}

