/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.configuration.cobrand;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yodlee.sdk.configuration.cobrand.AbstractBaseConfiguration;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class AbstractJWTConfiguration
extends AbstractBaseConfiguration {
    private static final long serialVersionUID = 1L;
    @NotEmpty(message="{config.jwt.apiKey.required}")
    @JsonProperty(value="apiKey")
    protected String apiKey;
    @NotEmpty(message="{config.jwt.privateKey.required}")
    @JsonProperty(value="privateKey")
    protected String privateKey;
    @NotNull(message="{config.jwt.expiresIn.required}")
    @Min(value=1L, message="{config.jwt.expiresIn.minimum}")
    @JsonProperty(value="expiresIn")
    protected int expiresIn = 1800;

    public AbstractJWTConfiguration() {
    }

    public AbstractJWTConfiguration(String basePath, String apiVersion, String apiKey, String privateKey, Integer expiresIn) {
        super(basePath, apiVersion);
        this.apiKey = apiKey;
        this.privateKey = privateKey;
        this.expiresIn = expiresIn;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }
}

