/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.context;

import com.yodlee.sdk.configuration.cobrand.AbstractClientCredentialConfiguration;
import com.yodlee.sdk.context.AbstractContext;
import com.yodlee.sdk.context.ContextType;

public abstract class AbstractClientCredentialContext<C extends AbstractClientCredentialConfiguration>
extends AbstractContext<C> {
    private static final long serialVersionUID = 1L;
    private String accessToken;
    private String issuedAt;
    private int expiresIn;
    private String contextHeader;
    private final C clientCredentialConfiguration;
    private boolean autoRenew;

    public AbstractClientCredentialContext(String accessToken, String issuedAt, int expiresIn, C clientCredentialConfiguration) {
        this.clientCredentialConfiguration = clientCredentialConfiguration;
        this.accessToken = accessToken;
        this.issuedAt = issuedAt;
        this.expiresIn = expiresIn;
        this.autoRenew = true;
        this.updateContextHeader(accessToken);
    }

    @Override
    public ContextType getContextType() {
        return ContextType.COBRAND;
    }

    @Override
    public C getConfiguration() {
        return this.clientCredentialConfiguration;
    }

    @Override
    protected String getContextHeader() {
        return this.contextHeader;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(String issuedAt) {
        this.issuedAt = issuedAt;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    private void updateContextHeader(String accessToken) {
        this.contextHeader = String.format("Bearer %s", accessToken);
    }

    @Override
    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    @Override
    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }
}

