/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.context;

import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.configuration.cobrand.AbstractBaseConfiguration;
import com.yodlee.sdk.context.Context;
import java.util.Map;
import java.util.Set;

public abstract class AbstractContext<T extends AbstractBaseConfiguration>
implements Context<T> {
    private static final long serialVersionUID = 1L;

    protected abstract String getContextHeader();

    @Override
    public ApiClient getApiClient(Map<String, String> requestHeaderMap) {
        ApiClient apiClient = new ApiClient(this);
        AbstractBaseConfiguration configuration = (AbstractBaseConfiguration)this.getConfiguration();
        apiClient.setBasePath(configuration.getBasePath());
        apiClient.addHeader("Api-Version", configuration.getApiVersion());
        apiClient.addHeader("Authorization", this.getContextHeader());
        if (requestHeaderMap != null) {
            Set<Map.Entry<String, String>> entrySet = requestHeaderMap.entrySet();
            for (Map.Entry<String, String> headermap : entrySet) {
                if (headermap.getKey() == null || headermap.getValue() == null) continue;
                apiClient.addHeader(headermap.getKey(), headermap.getValue());
            }
        }
        if (configuration.getSocketTimeout() != null) {
            apiClient.setConnectTimeout(configuration.getSocketTimeout());
        }
        if (configuration.getReadTimeout() != null) {
            apiClient.setReadTimeout(configuration.getReadTimeout());
        }
        if (configuration.getWriteTimeout() != null) {
            apiClient.setWriteTimeout(configuration.getWriteTimeout());
        }
        return apiClient;
    }
}

