/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.context;

import com.yodlee.sdk.configuration.cobrand.AbstractJWTConfiguration;
import com.yodlee.sdk.context.AbstractContext;

public abstract class AbstractJWTContext<C extends AbstractJWTConfiguration>
extends AbstractContext<C> {
    private static final long serialVersionUID = 1L;
    protected final C configuration;
    protected String jwtToken;
    private String contextHeader;
    private boolean autoRenew = true;

    public AbstractJWTContext(String jwtToken, C configuration) {
        this.jwtToken = jwtToken;
        this.configuration = configuration;
        this.autoRenew = true;
        this.updateContextHeader(jwtToken);
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
        this.updateContextHeader(jwtToken);
    }

    @Override
    protected String getContextHeader() {
        return this.contextHeader;
    }

    @Override
    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    @Override
    public void setAutoRenew(boolean autoRenewToken) {
        this.autoRenew = autoRenewToken;
    }

    private void updateContextHeader(String jwtToken) {
        this.contextHeader = String.format("Bearer %s", jwtToken);
    }
}

