/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.context;

import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.configuration.cobrand.CobrandConfiguration;
import com.yodlee.sdk.context.AbstractContext;
import com.yodlee.sdk.context.ContextType;
import java.util.Map;

public class CobrandContext
extends AbstractContext<CobrandConfiguration> {
    private static final long serialVersionUID = 1L;
    private final String cobSession;
    private final CobrandConfiguration cobrandConfiguration;
    private final String contextHeader;
    private boolean autoRenew = false;

    public CobrandContext(String cobSession, CobrandConfiguration cobrandConfiguration) {
        this.cobSession = cobSession;
        this.cobrandConfiguration = cobrandConfiguration;
        this.contextHeader = String.format("{cobSession=%s}", cobSession);
    }

    @Override
    public ContextType getContextType() {
        return ContextType.COBRAND;
    }

    @Override
    protected String getContextHeader() {
        return this.contextHeader;
    }

    @Override
    public ApiClient getApiClient(Map<String, String> requestHeaderMap) {
        ApiClient apiClient = super.getApiClient(requestHeaderMap);
        apiClient.addHeader("Cobrand-Name", this.cobrandConfiguration.getName());
        return apiClient;
    }

    @Override
    public CobrandConfiguration getConfiguration() {
        return this.cobrandConfiguration;
    }

    @Override
    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    @Override
    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public String getCobSession() {
        return this.cobSession;
    }
}

