/*
 * Decompiled with CFR 0.152.
 */
package com.yodlee.sdk.context;

import com.yodlee.sdk.client.ApiClient;
import com.yodlee.sdk.configuration.user.UserConfiguration;
import com.yodlee.sdk.context.AbstractContext;
import com.yodlee.sdk.context.ContextType;
import java.util.Map;

public class UserContext
extends AbstractContext<UserConfiguration> {
    private static final long serialVersionUID = 1L;
    private final String cobsession;
    private final String userSession;
    private final String contextHeader;
    private final UserConfiguration userConfiguration;
    private boolean autoRenew;

    public UserContext(String cobsession, String userSession, UserConfiguration userConfiguration) {
        this.cobsession = cobsession;
        this.userSession = userSession;
        this.contextHeader = String.format("{cobSession=%s},{userSession=%s}", cobsession, userSession);
        this.userConfiguration = userConfiguration;
    }

    @Override
    public ContextType getContextType() {
        return ContextType.USER;
    }

    public String getCobsession() {
        return this.cobsession;
    }

    public String getUserSession() {
        return this.userSession;
    }

    @Override
    public ApiClient getApiClient(Map<String, String> requestHeaderMap) {
        ApiClient apiClient = super.getApiClient(requestHeaderMap);
        apiClient.addHeader("Cobrand-Name", this.userConfiguration.getName());
        return apiClient;
    }

    @Override
    protected String getContextHeader() {
        return this.contextHeader;
    }

    @Override
    public UserConfiguration getConfiguration() {
        return this.userConfiguration;
    }

    @Override
    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    @Override
    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }
}

