/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.jshint;

import de.acosix.maven.jshint.Error;
import de.acosix.maven.jshint.JSHinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJSHinter
implements JSHinter {
    protected final Log log;
    protected Map<File, String> effectiveJSHintConfig = new HashMap<File, String>();

    public AbstractJSHinter(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("log not provided");
        }
        this.log = log;
    }

    @Override
    public synchronized List<Error> executeJSHint(File baseDirectory, String path, String defaultJSHintConfigContent, boolean ignoreJSConfigFileOnPaths) {
        String effectiveJSHintConfigContent;
        if (baseDirectory == null) {
            throw new IllegalArgumentException("baseDirectory not provided");
        }
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("path not provided");
        }
        if (StringUtils.isBlank((String)defaultJSHintConfigContent)) {
            throw new IllegalArgumentException("defaultJSHintConfigContent not provided");
        }
        this.log.info((CharSequence)MessageFormat.format("Executing JSHint on {0}{1}{2}", baseDirectory.getPath(), File.separator, path));
        if (ignoreJSConfigFileOnPaths) {
            effectiveJSHintConfigContent = defaultJSHintConfigContent;
        } else {
            effectiveJSHintConfigContent = this.lookupCustomJSHintConfig(baseDirectory, path);
            if (StringUtils.isBlank((String)effectiveJSHintConfigContent)) {
                effectiveJSHintConfigContent = defaultJSHintConfigContent;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Using effective JSHint config: " + effectiveJSHintConfigContent));
        }
        List<Error> errors = this.executeJSHintImpl(baseDirectory, path, effectiveJSHintConfigContent);
        this.reportErrors(errors);
        return errors;
    }

    protected abstract List<Error> executeJSHintImpl(File var1, String var2, String var3);

    protected List<String> readSourceLines(File baseDirectory, String path) {
        ArrayList<String> sourceLines = new ArrayList<String>();
        FileInputStream fin = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            File jshintIgnoreFile = new File(baseDirectory, path);
            fin = new FileInputStream(jshintIgnoreFile);
            isr = new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8);
            reader = new BufferedReader(isr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sourceLines.add(line);
            }
        }
        catch (IOException ioex) {
            try {
                throw new RuntimeException((Throwable)new MojoExecutionException("Error loading " + baseDirectory + File.separator + path, (Exception)ioex));
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close(isr);
                IOUtil.close(fin);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        IOUtil.close((Reader)isr);
        IOUtil.close((InputStream)fin);
        return sourceLines;
    }

    protected String lookupCustomJSHintConfig(File baseDirectory, String path) {
        String customJSHintConfig = null;
        int lastSeparatorIdx = path.lastIndexOf(File.separator);
        if (lastSeparatorIdx != -1) {
            String subPath = path.substring(0, lastSeparatorIdx);
            File pathKey = new File(baseDirectory, subPath);
            if (this.effectiveJSHintConfig.containsKey(pathKey)) {
                customJSHintConfig = this.effectiveJSHintConfig.get(pathKey);
            } else {
                File configFile = new File(pathKey, ".jshintrc");
                if (configFile.isFile() && configFile.exists()) {
                    customJSHintConfig = this.readSource(configFile);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((CharSequence)MessageFormat.format("Loaded custom JSHint config from {0}: {1}", configFile, customJSHintConfig));
                    }
                    this.effectiveJSHintConfig.put(pathKey, customJSHintConfig);
                } else {
                    customJSHintConfig = this.lookupCustomJSHintConfig(baseDirectory, subPath);
                }
            }
        } else if (this.effectiveJSHintConfig.containsKey(baseDirectory)) {
            customJSHintConfig = this.effectiveJSHintConfig.get(baseDirectory);
        } else {
            File configFile = new File(baseDirectory, ".jshintrc");
            if (configFile.isFile() && configFile.exists()) {
                customJSHintConfig = this.readSource(configFile);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)MessageFormat.format("Loaded custom JSHint config from {0}: {1}", configFile, customJSHintConfig));
                }
                this.effectiveJSHintConfig.put(baseDirectory, customJSHintConfig);
            }
        }
        return customJSHintConfig;
    }

    protected String readSource(File contentFile) {
        String source;
        FileInputStream fin = null;
        InputStreamReader isr = null;
        try {
            fin = new FileInputStream(contentFile);
            isr = new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8);
            source = IOUtil.toString((Reader)isr);
        }
        catch (IOException ioex) {
            try {
                throw new RuntimeException((Throwable)new MojoExecutionException("Error loading " + contentFile.toPath(), (Exception)ioex));
            }
            catch (Throwable throwable) {
                IOUtil.close(isr);
                IOUtil.close((InputStream)fin);
                throw throwable;
            }
        }
        IOUtil.close((Reader)isr);
        IOUtil.close((InputStream)fin);
        return source;
    }

    protected void reportErrors(List<Error> errors) {
        for (Error error : errors) {
            this.log.error((CharSequence)MessageFormat.format("{0},{1}: {2} ({3})", String.valueOf(error.getLine()), String.valueOf(error.getCharacter()), error.getReason(), error.getCode()));
        }
    }
}

