/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.jshint;

import de.acosix.maven.jshint.Error;
import de.acosix.maven.jshint.JSHintReporter;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.plugin.MojoExecutionException;

public class CheckstyleJSHintReporter
implements JSHintReporter {
    @Override
    public void generateReport(Map<String, List<Error>> errorsByFile, OutputStream os) {
        XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter w = outFactory.createXMLStreamWriter(os, StandardCharsets.UTF_8.name());
            w = new IndentingXMLStreamWriter(w);
            w.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            w.writeStartElement("checkstyle");
            w.writeAttribute("version", "7.1.2");
            for (Map.Entry<String, List<Error>> fileEntry : errorsByFile.entrySet()) {
                String filePath = fileEntry.getKey();
                List<Error> errors = fileEntry.getValue();
                w.writeStartElement("file");
                w.writeAttribute("name", filePath);
                for (Error error : errors) {
                    w.writeStartElement("error");
                    w.writeAttribute("line", String.valueOf(error.getLine()));
                    w.writeAttribute("column", String.valueOf(error.getCharacter()));
                    String code = error.getCode();
                    String severity = code.startsWith("E") ? "error" : "warning";
                    w.writeAttribute("severity", severity);
                    w.writeAttribute("message", error.getReason());
                    w.writeEndElement();
                }
                w.writeEndElement();
            }
            w.writeEndElement();
        }
        catch (XMLStreamException xsex) {
            throw new RuntimeException((Throwable)new MojoExecutionException("Error writing checkstyle report output", (Exception)xsex));
        }
    }
}

