/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.jshint;

import de.acosix.maven.jshint.AbstractJSHinter;
import de.acosix.maven.jshint.CheckstyleJSHintReporter;
import de.acosix.maven.jshint.Error;
import de.acosix.maven.jshint.NashornJSHinter;
import de.acosix.maven.jshint.RhinoJSHinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="jshint", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class JSHintMojo
extends AbstractMojo {
    private static final boolean NASHORN_AVAILABLE;
    @Parameter(defaultValue="${project.basedir}", property="baseDirectory", required=true, readonly=true)
    protected File baseDirectory;
    @Parameter(defaultValue="${project.build.directory}", property="outputDirectory", required=true, readonly=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project.basedir}/src/main", property="sourceDirectory", required=true)
    protected File sourceDirectory;
    @Parameter(defaultValue=".jshintrc", property="jsHintDefaultConfigFile", required=true)
    protected String jsHintDefaultConfigFile;
    @Parameter(property="includes", required=false)
    protected List<String> includes;
    @Parameter(property="excludes", required=false)
    protected List<String> excludes;
    @Parameter(property="failOnError", required=false)
    protected boolean failOnError = true;
    @Parameter(property="preferRhino", required=false)
    protected boolean preferRhino = false;
    @Parameter(property="ignoreJSHintIgnoreFiles", required=false)
    protected boolean ignoreJSHintIgnoreFiles = false;
    @Parameter(property="ignoreJSHintConfigFiles", required=false)
    protected boolean ignoreJSHintConfigFiles = false;
    @Parameter(defaultValue="2.9.3", property="jshintVersion", required=true)
    protected String jshintVersion;
    @Parameter(property="jshintScript", required=false)
    protected String jshintScript;
    @Parameter(property="checkstyleReportFile", required=false)
    protected String checkstyleReportFile;
    @Parameter(property="skip", required=false)
    protected boolean skip;

    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = new File(baseDirectory);
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = new File(sourceDirectory);
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setJsHintDefaultConfigFile(String jsHintDefaultConfigFile) {
        this.jsHintDefaultConfigFile = jsHintDefaultConfigFile;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setPreferRhino(boolean preferRhino) {
        this.preferRhino = preferRhino;
    }

    public void setIgnoreJSHintIgnoreFiles(boolean ignoreJSHintIgnoreFiles) {
        this.ignoreJSHintIgnoreFiles = ignoreJSHintIgnoreFiles;
    }

    public void setIgnoreJSHintConfigFiles(boolean ignoreJSHintConfigFiles) {
        this.ignoreJSHintConfigFiles = ignoreJSHintConfigFiles;
    }

    public void setJshintVersion(String jshintVersion) {
        this.jshintVersion = jshintVersion;
    }

    public void setJshintScript(String jshintScript) {
        this.jshintScript = jshintScript;
    }

    public void setCheckstyleReportFile(String checkstyleReportFile) {
        this.checkstyleReportFile = checkstyleReportFile;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping JSHint");
            return;
        }
        try {
            File scriptFile;
            List<String> scriptFilesToProcess = this.lookupJavaScriptFilesToInclude();
            AbstractJSHinter hinter = this.jshintScript != null ? ((scriptFile = new File(this.baseDirectory, this.jshintScript)).isFile() && scriptFile.exists() ? (this.preferRhino || !NASHORN_AVAILABLE ? new RhinoJSHinter(this.getLog(), scriptFile) : new NashornJSHinter(this.getLog(), scriptFile)) : (this.preferRhino || !NASHORN_AVAILABLE ? new RhinoJSHinter(this.getLog(), this.jshintScript, true) : new NashornJSHinter(this.getLog(), this.jshintScript, true))) : (this.preferRhino || !NASHORN_AVAILABLE ? new RhinoJSHinter(this.getLog(), this.jshintVersion, false) : new NashornJSHinter(this.getLog(), this.jshintVersion, false));
            String defaultJSHintConfigContent = this.loadDefaultJSHintConfig();
            int filesChecked = 0;
            int filesWithErrors = 0;
            HashMap<String, List<Error>> errorsByFile = new HashMap<String, List<Error>>();
            for (String scriptFile2 : scriptFilesToProcess) {
                List<Error> errors = hinter.executeJSHint(this.sourceDirectory, scriptFile2, defaultJSHintConfigContent, this.ignoreJSHintConfigFiles);
                if (!errors.isEmpty()) {
                    ++filesWithErrors;
                    errorsByFile.put(scriptFile2, errors);
                }
                ++filesChecked;
            }
            this.getLog().info((CharSequence)"JSHint validation complete");
            if (filesWithErrors > 0) {
                String message = MessageFormat.format("JSHint errors found in {0} source files", String.valueOf(filesWithErrors));
                this.getLog().error((CharSequence)message);
                this.writeReports(errorsByFile);
                if (this.failOnError) {
                    throw new MojoFailureException(message);
                }
            } else {
                this.getLog().info((CharSequence)MessageFormat.format("No JSHint errors found in {0} source files", String.valueOf(filesChecked)));
            }
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof MojoExecutionException) {
                throw (MojoExecutionException)re.getCause();
            }
            throw re;
        }
    }

    protected void writeReports(Map<String, List<Error>> errorsByFile) {
        if (StringUtils.isNotBlank((String)this.checkstyleReportFile)) {
            File checkstyleReportFile;
            File parentDirectory;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Writing error report to checkstyle file: " + this.checkstyleReportFile));
            }
            if (!(parentDirectory = (checkstyleReportFile = new File(this.outputDirectory, this.checkstyleReportFile)).getParentFile()).exists()) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Creating report parent director(y|ies): " + parentDirectory));
                }
                parentDirectory.mkdirs();
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(checkstyleReportFile, false);
                CheckstyleJSHintReporter checkstyleJSHintReporter = new CheckstyleJSHintReporter();
                checkstyleJSHintReporter.generateReport(errorsByFile, os);
            }
            catch (IOException ioex) {
                try {
                    throw new RuntimeException((Throwable)new MojoExecutionException("Failed to write checkstyle report file", (Exception)ioex));
                }
                catch (Throwable throwable) {
                    IOUtil.close(os);
                    throw throwable;
                }
            }
            IOUtil.close((OutputStream)os);
        }
    }

    protected String loadDefaultJSHintConfig() {
        String defaultJSHintConfigContent;
        File jsHintDefaultConfigFile = new File(this.baseDirectory, this.jsHintDefaultConfigFile);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)MessageFormat.format("JSHint default config file {0} - file in base directory: {1}, exists:{2}", jsHintDefaultConfigFile, jsHintDefaultConfigFile.isFile(), jsHintDefaultConfigFile.exists()));
        }
        if (!jsHintDefaultConfigFile.isFile() || !jsHintDefaultConfigFile.exists()) {
            URL jsHintDefaultConfigResource = JSHintMojo.class.getClassLoader().getResource(this.jsHintDefaultConfigFile);
            if (jsHintDefaultConfigResource != null) {
                InputStreamReader jsHintConfigReader = null;
                InputStream is = null;
                try {
                    is = jsHintDefaultConfigResource.openStream();
                    jsHintConfigReader = new InputStreamReader(is, StandardCharsets.UTF_8);
                    defaultJSHintConfigContent = IOUtil.toString((Reader)jsHintConfigReader);
                }
                catch (IOException ioex) {
                    IOUtil.close(jsHintConfigReader);
                    IOUtil.close((InputStream)is);
                    throw new RuntimeException((Throwable)new MojoExecutionException("Error reading default JSHint config from " + this.jsHintDefaultConfigFile, (Exception)ioex));
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)MessageFormat.format("JSHint default config file {0} loaded from classpath", this.jsHintDefaultConfigFile));
                }
            } else {
                defaultJSHintConfigContent = "{}";
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)MessageFormat.format("Using empty config as JSHint default config file {0} could not be found in project or on classpath", this.jsHintDefaultConfigFile));
                }
            }
        } else {
            InputStreamReader jsHintConfigReader = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(jsHintDefaultConfigFile);
                jsHintConfigReader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                defaultJSHintConfigContent = IOUtil.toString((Reader)jsHintConfigReader);
            }
            catch (IOException ioex) {
                IOUtil.close(jsHintConfigReader);
                IOUtil.close((InputStream)fis);
                throw new RuntimeException((Throwable)new MojoExecutionException("Error reading default JSHint config file" + this.jsHintDefaultConfigFile, (Exception)ioex));
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Loaded default JSHint config: " + defaultJSHintConfigContent));
        }
        return defaultJSHintConfigContent;
    }

    protected List<String> lookupJavaScriptFilesToInclude() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        if (this.includes != null && !this.includes.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using configured inclusion patterns: " + this.includes));
            }
            scanner.setIncludes(this.includes.toArray(new String[0]));
        } else {
            this.getLog().debug((CharSequence)"Using default inclusion patterns *.js and  **/*.js");
            scanner.setIncludes(new String[]{"*.js", "**/*.js"});
        }
        ArrayList<String> effectiveExcludes = new ArrayList<String>();
        if (this.excludes != null && !this.excludes.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using configured exclusion patterns: " + this.excludes));
            }
            effectiveExcludes.addAll(this.excludes);
        }
        if (!this.ignoreJSHintIgnoreFiles) {
            List<String> jshintIgnoreExcludes = this.loadExcludesFromJSHintIgnores();
            effectiveExcludes.addAll(jshintIgnoreExcludes);
        }
        scanner.setExcludes(effectiveExcludes.toArray(new String[0]));
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> javaScriptFilesToInclude = Arrays.asList(scanner.getIncludedFiles());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Determined set of JavaScript files to process: " + javaScriptFilesToInclude));
        }
        return javaScriptFilesToInclude;
    }

    protected List<String> loadExcludesFromJSHintIgnores() {
        String[] jshintIgnores;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setIncludes(new String[]{".jshintignore", "**/.jshintignore"});
        scanner.scan();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String jshintIgnore : jshintIgnores = scanner.getIncludedFiles()) {
            ArrayList<String> excludesFromFile = new ArrayList<String>();
            String path = jshintIgnore.contains(File.separator) ? jshintIgnore.substring(0, jshintIgnore.lastIndexOf(File.separator)) : null;
            FileInputStream fin = null;
            InputStreamReader isr = null;
            BufferedReader reader = null;
            try {
                File jshintIgnoreFile = new File(this.sourceDirectory, jshintIgnore);
                fin = new FileInputStream(jshintIgnoreFile);
                isr = new InputStreamReader((InputStream)fin, StandardCharsets.UTF_8);
                reader = new BufferedReader(isr);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (StringUtils.isBlank((String)line)) continue;
                    excludesFromFile.add(line);
                    if (path != null) {
                        excludes.add(path + File.separator + line);
                        continue;
                    }
                    excludes.add(line);
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)MessageFormat.format("Loaded exclusion patterns {0} from {1}", excludesFromFile, jshintIgnoreFile));
                }
            }
            catch (IOException ioex) {
                try {
                    throw new RuntimeException((Throwable)new MojoExecutionException("Error loading .jshintignore", (Exception)ioex));
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    IOUtil.close(isr);
                    IOUtil.close(fin);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
            IOUtil.close((Reader)isr);
            IOUtil.close((InputStream)fin);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Loaded excludes from .jshintignore files: " + excludes));
        }
        return excludes;
    }

    static {
        boolean nashornAvailable = false;
        try {
            ScriptEngineManager engineManager = new ScriptEngineManager();
            ScriptEngine nashornEngine = engineManager.getEngineByName("nashorn");
            nashornAvailable = nashornEngine != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        NASHORN_AVAILABLE = nashornAvailable;
    }
}

