/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.jshint;

import de.acosix.maven.jshint.AbstractJSHinter;
import de.acosix.maven.jshint.Error;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class NashornJSHinter
extends AbstractJSHinter {
    protected final ScriptEngine nashornEngine = new ScriptEngineManager().getEngineByName("nashorn");
    protected final Bindings bindings = this.nashornEngine.createBindings();
    protected final Object jshintScript;
    protected boolean jshintScriptLoaded = false;

    public NashornJSHinter(Log log, String versionOrResourcePath, boolean resourcePath) {
        super(log);
        if (StringUtils.isBlank((String)versionOrResourcePath)) {
            throw new IllegalArgumentException("versionOrResourcePath not provided");
        }
        if (!resourcePath) {
            String scriptName = "jshint-" + versionOrResourcePath + "-nashorn.js";
            this.jshintScript = NashornJSHinter.class.getResource(scriptName);
            if (this.jshintScript == null) {
                this.log.error((CharSequence)("JSHint script could not be resolved for version " + versionOrResourcePath));
                throw new RuntimeException((Throwable)new MojoExecutionException("Error resolving " + scriptName));
            }
        } else {
            this.jshintScript = NashornJSHinter.class.getClassLoader().getResource(versionOrResourcePath);
            if (this.jshintScript == null) {
                this.log.error((CharSequence)("JSHint script could not be resolved from resource path " + versionOrResourcePath));
                throw new RuntimeException((Throwable)new MojoExecutionException("Error resolving " + versionOrResourcePath));
            }
        }
    }

    public NashornJSHinter(Log log, File jshintScriptFile) {
        super(log);
        this.jshintScript = jshintScriptFile;
    }

    @Override
    protected List<Error> executeJSHintImpl(File baseDirectory, String path, String effectiveJSHintConfigContent) {
        this.ensureEngineInitialisation();
        ArrayList<Error> errors = new ArrayList<Error>();
        List<String> sourceLines = this.readSourceLines(baseDirectory, path);
        this.bindings.put("sourceLines", (Object)sourceLines);
        this.bindings.put("errors", (Object)errors);
        this.bindings.put("jshintConfig", (Object)effectiveJSHintConfigContent);
        URL runnerScript = NashornJSHinter.class.getResource("jshint-nashorn-runner.js");
        this.bindings.put("runnerScript", (Object)runnerScript);
        try {
            this.nashornEngine.eval("load(runnerScript);", this.bindings);
        }
        catch (ScriptException sex) {
            throw new RuntimeException((Throwable)new MojoExecutionException("Error running jshint validations", (Exception)sex));
        }
        return errors;
    }

    protected void ensureEngineInitialisation() {
        if (!this.jshintScriptLoaded) {
            this.log.debug((CharSequence)"Initialising Nashorn context for JSHint");
            this.bindings.put("jshintScript", this.jshintScript);
            try {
                this.nashornEngine.eval("load(jshintScript);", this.bindings);
            }
            catch (ScriptException sex) {
                throw new RuntimeException((Throwable)new MojoExecutionException("Error loading jshint script", (Exception)sex));
            }
            this.jshintScriptLoaded = true;
        }
    }
}

