/*
 * Decompiled with CFR 0.152.
 */
package de.acosix.maven.jshint;

import de.acosix.maven.jshint.AbstractJSHinter;
import de.acosix.maven.jshint.Error;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

public class RhinoJSHinter
extends AbstractJSHinter {
    protected final Object jshintScript;
    protected Scriptable scope;
    protected Script runnerScript;

    public RhinoJSHinter(Log log, String versionOrResourcePath, boolean resourcePath) {
        super(log);
        if (StringUtils.isBlank((String)versionOrResourcePath)) {
            throw new IllegalArgumentException("versionOrResourcePath not provided");
        }
        if (!resourcePath) {
            String scriptName = "jshint-" + versionOrResourcePath + "-rhino.js";
            this.jshintScript = RhinoJSHinter.class.getResource(scriptName);
            if (this.jshintScript == null) {
                this.log.error((CharSequence)("JSHint script could not be resolved for version " + versionOrResourcePath));
                throw new RuntimeException((Throwable)new MojoExecutionException("Error resolving " + scriptName));
            }
        } else {
            this.jshintScript = RhinoJSHinter.class.getClassLoader().getResource(versionOrResourcePath);
            if (this.jshintScript == null) {
                this.log.error((CharSequence)("JSHint script could not be resolved from resource path " + versionOrResourcePath));
                throw new RuntimeException((Throwable)new MojoExecutionException("Error resolving " + versionOrResourcePath));
            }
        }
    }

    public RhinoJSHinter(Log log, File jshintScriptFile) {
        super(log);
        this.jshintScript = jshintScriptFile;
    }

    @Override
    protected List<Error> executeJSHintImpl(File baseDirectory, String path, String effectiveJSHintConfigContent) {
        this.ensureEngineInitialisation();
        ArrayList<Error> errors = new ArrayList<Error>();
        Context cx = Context.enter();
        try {
            List<String> sourceLines = this.readSourceLines(baseDirectory, path);
            Scriptable sourceLinesArr = cx.newArray(this.scope, sourceLines.toArray(new Object[0]));
            this.scope.put("errors", this.scope, errors);
            this.scope.put("sourceLines", this.scope, (Object)sourceLinesArr);
            this.scope.put("jshintConfig", this.scope, (Object)effectiveJSHintConfigContent);
            this.runnerScript.exec(cx, this.scope);
        }
        catch (JavaScriptException jse) {
            Object value = jse.getValue();
            if (value instanceof NativeJavaObject) {
                value = ((NativeJavaObject)value).unwrap();
            }
            if (value instanceof RuntimeException) {
                throw (RuntimeException)value;
            }
            throw jse;
        }
        catch (WrappedException we) {
            Throwable wrapped = we.getWrappedException();
            if (wrapped instanceof RuntimeException) {
                throw (RuntimeException)wrapped;
            }
            throw we;
        }
        finally {
            Context.exit();
        }
        return errors;
    }

    protected void ensureEngineInitialisation() {
        if (this.scope == null) {
            this.log.debug((CharSequence)"Initialising Rhino context for JSHint");
            Context cx = Context.enter();
            try {
                this.scope = cx.initStandardObjects(null, false);
                Script jshintScript = this.compileJSHintScript(cx);
                jshintScript.exec(cx, this.scope);
                this.runnerScript = this.compileInternalScriptScript(cx, "jshint-rhino-runner.js");
            }
            catch (IOException ioex) {
                this.log.error((CharSequence)"Error initialising Rhino context for JSHint");
                throw new RuntimeException((Throwable)new MojoExecutionException("Error initialising Rhino context for JSHint", (Exception)ioex));
            }
            finally {
                Context.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Script compileJSHintScript(Context cx) throws IOException {
        Script jshintScript;
        if (this.jshintScript instanceof URL) {
            URL jshintScriptURL = (URL)this.jshintScript;
            InputStream scriptInputStream = jshintScriptURL.openStream();
            try {
                jshintScript = this.compileScript(cx, jshintScriptURL.toExternalForm(), scriptInputStream);
            }
            finally {
                IOUtil.close((InputStream)scriptInputStream);
            }
        } else if (this.jshintScript instanceof File) {
            FileInputStream scriptInputStream = new FileInputStream((File)this.jshintScript);
            try {
                jshintScript = this.compileScript(cx, ((File)this.jshintScript).getAbsolutePath(), scriptInputStream);
            }
            finally {
                IOUtil.close((InputStream)scriptInputStream);
            }
        } else {
            throw new RuntimeException((Throwable)new MojoExecutionException("JSHint script has not been resolved"));
        }
        return jshintScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Script compileInternalScriptScript(Context cx, String scriptName) throws IOException {
        InputStream scriptInputStream = RhinoJSHinter.class.getResourceAsStream(scriptName);
        try {
            Script script;
            Script script2 = script = this.compileScript(cx, scriptName, scriptInputStream);
            return script2;
        }
        finally {
            IOUtil.close((InputStream)scriptInputStream);
        }
    }

    protected Script compileScript(Context cx, String name, InputStream is) throws IOException {
        InputStreamReader scriptReader = new InputStreamReader(is, StandardCharsets.UTF_8);
        Script script = cx.compileReader((Reader)scriptReader, name, 1, null);
        return script;
    }
}

