/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.tabs;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class BootstrapTabbedPanel<T extends ITab>
extends TabbedPanel<T> {
    private static final long serialVersionUID = 1L;

    public BootstrapTabbedPanel(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public BootstrapTabbedPanel(String id, List<T> tabs, IModel<Integer> model) {
        super(id, tabs, model);
        BootstrapBaseBehavior.addTo((Component)this);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
    }

    protected String getSelectedTabCssClass() {
        return "active";
    }

    protected String getLastTabCssClass() {
        return "";
    }

    protected String getTabContainerCssClass() {
        return "nav nav-tabs";
    }

    protected WebMarkupContainer addSelectedTabBehavior(WebMarkupContainer link, final int index) {
        link.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                if (index == BootstrapTabbedPanel.this.getSelectedTab()) {
                    tag.append("class", (CharSequence)BootstrapTabbedPanel.this.getSelectedTabCssClass(), " ");
                }
            }

            public boolean isTemporary(Component component) {
                return true;
            }
        }});
        return link;
    }

    protected WebMarkupContainer newLink(String linkId, int index) {
        WebMarkupContainer link = super.newLink(linkId, index);
        return this.addSelectedTabBehavior(link, index);
    }
}

