/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.behavior;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.webjars.request.resource.WebjarsCssResourceReference;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;

public class AnimatedBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final String CDN_PATTERN = "//cdnjs.cloudflare.com/ajax/libs/animate.css/%s/animate.min.css";
    private final Animation animation;
    private String cdnUrl;

    public AnimatedBehavior(Animation animation) {
        this.animation = animation;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.useCdnResources()) {
            if (this.cdnUrl == null) {
                this.cdnUrl = String.format(CDN_PATTERN, this.getCdnVersion());
            }
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new UrlResourceReference(Url.parse((CharSequence)this.cdnUrl))));
        } else {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new WebjarsCssResourceReference("animate.css/current/animate.css")));
        }
    }

    protected String getCdnVersion() {
        return "3.2.5";
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"animated", this.animation.cssClassName()});
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo((Component)component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom((Component)component);
    }

    private boolean useCdnResources() {
        boolean result = false;
        if (Application.exists()) {
            IBootstrapSettings settings = Bootstrap.getSettings();
            result = settings.useCdnResources();
        }
        return result;
    }

    public static enum Animation implements ICssClassNameProvider
    {
        bounce,
        flash,
        pulse,
        rubberBand,
        shake,
        swing,
        tada,
        wabble,
        bounceIn,
        bounceInDown,
        bounceInLeft,
        bounceInRight,
        bounceInUp,
        bounceOut,
        bounceOutDown,
        bounceOutLeft,
        bounceOutRight,
        bounceOutUp,
        fadeIn,
        fadeInDown,
        fadeInDownBig,
        fadeInLeft,
        fadeInLeftBig,
        fadeInRight,
        fadeInRightBig,
        fadeInUp,
        fadeInUpBig,
        fadeOut,
        fadeOutDown,
        fadeOutDownBig,
        fadeOutLeft,
        fadeOutLeftBig,
        fadeOutRight,
        fadeOutRightBig,
        fadeInUpDown,
        fadeOutUpBig,
        flip,
        flipInX,
        flipInY,
        flipOutX,
        flipOutY,
        lightSpeedIn,
        lightSpeedOut,
        rotateInDownLeft,
        rotateInDownRight,
        rotateInUpLeft,
        rotateInUpRight,
        rotateOutDownLeft,
        rotateOutDownRight,
        rotateOutUpLeft,
        rotateOutUpRight,
        slideInUp,
        slideInDown,
        slideInLeft,
        slideInRight,
        slideOutUp,
        slideOutDown,
        slideOutLeft,
        slideOutRight,
        zoomIn,
        zoomInDown,
        zoomInLeft,
        zoomInRight,
        zoomInUp,
        zoomOut,
        zoomOutDown,
        zoomOutLeft,
        zoomOutRight,
        zoomOutUp,
        hinge,
        rollIn,
        rollOut;


        public String cssClassName() {
            return this.name();
        }
    }
}

