/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.validation.AbstractValidationConfig;
import de.agilecoders.wicket.jquery.IKey;
import java.io.IOException;

public class TooltipValidationConfig
extends AbstractValidationConfig {
    private static final IKey<Boolean> Animation = TooltipValidationConfig.newKey((String)"animation", (Object)true);
    private static final IKey<String> Container = TooltipValidationConfig.newKey((String)"container", null);
    private static final IKey<Delay> Delay = TooltipValidationConfig.newKey((String)"delay", (Object)new Delay(0));
    private static final IKey<Boolean> Html = TooltipValidationConfig.newKey((String)"html", (Object)false);
    private static final IKey<String> Placement = TooltipValidationConfig.newKey((String)"placement", (Object)"top");
    private static final IKey<String> Selector = TooltipValidationConfig.newKey((String)"selector", null);
    private static final IKey<String> Template = TooltipValidationConfig.newKey((String)"template", null);
    private static final IKey<String> Title = TooltipValidationConfig.newKey((String)"title", (Object)"");
    private static final IKey<String> Trigger = TooltipValidationConfig.newKey((String)"trigger", (Object)"hover focus");
    private static final IKey<String> Viewport = TooltipValidationConfig.newKey((String)"viewport", (Object)"{selector: 'body', padding: 0}");
    private static final long serialVersionUID = 1L;

    public TooltipValidationConfig withAnimation(boolean use) {
        this.put(Animation, use);
        return this;
    }

    public TooltipValidationConfig withContainer(String value) {
        this.put(Container, value);
        return this;
    }

    public TooltipValidationConfig withDelay(Delay value) {
        this.put(Delay, value);
        return this;
    }

    public TooltipValidationConfig withHtml(boolean use) {
        this.put(Html, use);
        return this;
    }

    public TooltipValidationConfig withPlacement(TooltipConfig.Placement value) {
        this.put(Placement, value.name());
        return this;
    }

    public TooltipValidationConfig withSelector(String value) {
        this.put(Selector, value);
        return this;
    }

    public TooltipValidationConfig withTemplate(String value) {
        this.put(Template, value);
        return this;
    }

    public TooltipValidationConfig withTitle(String value) {
        this.put(Title, value);
        return this;
    }

    public TooltipValidationConfig withTrigger(String value) {
        this.put(Trigger, value);
        return this;
    }

    public TooltipValidationConfig withViewport(String value) {
        this.put(Viewport, value);
        return this;
    }

    @JsonSerialize(using=DelaySerializer.class)
    public static class Delay {
        private final int show;
        private final int hide;

        public Delay(int delay) {
            this(delay, delay);
        }

        public Delay(int show, int hide) {
            this.show = show;
            this.hide = hide;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Delay delay = (Delay)o;
            if (this.hide != delay.hide) {
                return false;
            }
            return this.show == delay.show;
        }

        public int hashCode() {
            int result = this.show;
            result = 31 * result + this.hide;
            return result;
        }
    }

    private static class DelaySerializer
    extends JsonSerializer<Delay> {
        private DelaySerializer() {
        }

        public void serialize(Delay value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value.show == value.hide) {
                jgen.writeNumber(value.show);
            } else {
                jgen.writeStartObject();
                jgen.writeObjectField("show", (Object)value.show);
                jgen.writeObjectField("hide", (Object)value.hide);
                jgen.writeEndObject();
            }
        }
    }
}

