/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.utils.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.codecentric.boot.admin.server.domain.values.Registration;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class RegistrationDeserializer
extends StdDeserializer<Registration> {
    private static final long serialVersionUID = 1L;

    public RegistrationDeserializer() {
        super(Registration.class);
    }

    public Registration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        Registration.Builder builder = Registration.builder();
        if (node.hasNonNull("name")) {
            builder.name(node.get("name").asText());
        }
        if (node.hasNonNull("url")) {
            String url = node.get("url").asText();
            builder.healthUrl(url.replaceFirst("/+$", "") + "/health").managementUrl(url);
        } else {
            if (node.hasNonNull("healthUrl")) {
                builder.healthUrl(node.get("healthUrl").asText());
            }
            if (node.hasNonNull("managementUrl")) {
                builder.managementUrl(node.get("managementUrl").asText());
            }
            if (node.hasNonNull("serviceUrl")) {
                builder.serviceUrl(node.get("serviceUrl").asText());
            }
        }
        if (node.has("metadata")) {
            Iterator it = node.get("metadata").fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                builder.metadata((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
        }
        if (node.hasNonNull("source")) {
            builder.source(node.get("source").asText());
        }
        return builder.build();
    }
}

