/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.archives;

import de.flapdoodle.embed.process.archives.AbstractExtractFileSet;
import de.flapdoodle.embed.process.archives.ArchiveStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipAdapter
extends AbstractExtractFileSet {
    @Override
    protected ArchiveStream archiveStream(Path source) throws IOException {
        ZipFile zipIn = new ZipFile(source.toFile());
        return new ZipArchiveWrapper(zipIn);
    }

    protected static class ZipArchiveWrapper
    implements ArchiveStream {
        private final Enumeration<ZipArchiveEntry> entries;
        private final ZipFile zFile;

        public ZipArchiveWrapper(ZipFile source) {
            this.zFile = source;
            this.entries = source.getEntries();
        }

        @Override
        public ArchiveEntry getNextEntry() {
            return this.entries.hasMoreElements() ? (ArchiveEntry)this.entries.nextElement() : null;
        }

        @Override
        public boolean canReadEntryData(ArchiveEntry entry) {
            return this.zFile.canReadEntryData(this.zFile.getEntry(entry.getName()));
        }

        @Override
        public void close() throws IOException {
            this.zFile.close();
        }

        @Override
        public InputStream asStream(ArchiveEntry entry) throws IOException {
            return this.zFile.getInputStream(this.zFile.getEntry(entry.getName()));
        }
    }
}

