/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io;

import de.flapdoodle.embed.process.io.StreamProcessor;
import java.io.IOException;
import java.io.Reader;

public class ReaderProcessor
extends Thread {
    private static final int CHAR_BUFFER_LENGTH = 512;
    private final Reader reader;
    private final StreamProcessor streamProcessor;

    protected ReaderProcessor(Reader reader, StreamProcessor streamProcessor) {
        this.reader = reader;
        this.streamProcessor = streamProcessor;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        try {
            int read;
            char[] buf = new char[512];
            while ((read = this.reader.read(buf)) != -1) {
                this.streamProcessor.process(new String(buf, 0, read));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.streamProcessor.onProcessed();
        }
    }

    public void abort() {
        try {
            this.interrupt();
            this.join(1000L);
        }
        catch (InterruptedException ix) {
            this.interrupt();
        }
    }

    public static void abortAll(ReaderProcessor ... readerProcessors) {
        if (readerProcessors.length > 0) {
            ReaderProcessor.abortIndex(0, readerProcessors);
        }
    }

    private static void abortIndex(int idx, ReaderProcessor[] readerProcessors) {
        if (readerProcessors.length > idx) {
            try {
                ReaderProcessor.abortIndex(idx + 1, readerProcessors);
            }
            finally {
                readerProcessors[idx].abort();
            }
        }
    }
}

