/*
 * Decompiled with CFR 0.152.
 */
package de.fumix.holidays.config.properties;

import de.fumix.holidays.config.Holiday;
import de.fumix.holidays.config.properties.PropNode;
import de.fumix.holidays.config.properties.TreeProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolidayProperties {
    private static final Logger LOG = LoggerFactory.getLogger(HolidayProperties.class);

    public static void from(LinkedHashMap<String, String> holidayProperties, Consumer<Holiday> holidayConsumer) {
        String logPrefix = "[from()]";
        TreeProperties holidayProps = TreeProperties.from(holidayProperties);
        Collection holidayNodes = holidayProps.root.get("holiday").map(PropNode::getChildren).orElse(Collections.emptyList());
        holidayNodes.stream().filter(hn -> hn.getValue().isPresent()).map(hn -> Holiday.fromConfig(hn.getKey(), hn.getValue().get())).peek(h -> LOG.debug("{} Loaded holiday: {}", (Object)"[from()]", h)).forEach(holidayConsumer);
    }
}

