/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.utils.AssertUtils;
import de.gsi.math.ArrayUtils;
import de.gsi.math.TMathConstants;

public final class ArrayMath {
    private static final String DIVISOR = "divisor";
    private static final String IN = "in";
    private static final String MULTIPLICATOR = "multiplicator";
    private static final String VALUE = "value";

    ArrayMath() {
        throw new IllegalStateException("Utility class");
    }

    public static double[] add(double[] in, double value) {
        return ArrayMath.add(in, in.length, value);
    }

    public static double[] add(double[] in, double[] value) {
        return ArrayMath.add(in, value, in.length);
    }

    public static double[] add(double[] in, double[] value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)length, (int)value.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i] + value[i];
        }
        return ret;
    }

    public static double[] add(double[] in, int length, double value) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i] + value;
        }
        return ret;
    }

    public static double[] addInPlace(double[] in, double value) {
        return ArrayMath.addInPlace(in, in.length, value);
    }

    public static double[] addInPlace(double[] in, double[] value) {
        return ArrayMath.addInPlace(in, value, in.length);
    }

    public static double[] addInPlace(double[] in, double[] value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)length, (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            in[n] = in[n] + value[i];
        }
        return in;
    }

    public static double[] addInPlace(double[] in, int length, double value) {
        AssertUtils.notNull((String)IN, (Object)in);
        int i = 0;
        while (i < length) {
            int n = i++;
            in[n] = in[n] + value;
        }
        return in;
    }

    public static double[] calculateFilterParameters(double cutoffFraction, FilterType filterType, double rippleP, double numberOfPoles, int iteration) {
        double rp = -Math.cos(Math.PI / (numberOfPoles * 2.0) + (double)(iteration - 1) * (Math.PI / numberOfPoles));
        double ip = Math.sin(Math.PI / (numberOfPoles * 2.0) + (double)(iteration - 1) * Math.PI / numberOfPoles);
        if (rippleP != 0.0) {
            double es = Math.sqrt(Math.pow(100.0 / (100.0 - rippleP), 2.0) - 1.0);
            double vx = 1.0 / numberOfPoles * Math.log(1.0 / es + Math.sqrt(1.0 / Math.pow(es, 2.0) + 1.0));
            double kx = 1.0 / numberOfPoles * Math.log(1.0 / es + Math.sqrt(1.0 / Math.pow(es, 2.0) - 1.0));
            kx = (Math.exp(kx) + Math.exp(-kx)) / 2.0;
            rp = rp * ((Math.exp(vx) - Math.exp(-vx)) / 2.0) / kx;
            ip = ip * ((Math.exp(vx) + Math.exp(-vx)) / 2.0) / kx;
        }
        double t = 2.0 * Math.tan(0.5);
        double w = Math.PI * 2 * cutoffFraction;
        double m = Math.pow(rp, 2.0) + Math.pow(ip, 2.0);
        double d = 4.0 - 4.0 * rp * t + m * Math.pow(t, 2.0);
        double x0 = Math.pow(t, 2.0) / d;
        double x1 = 2.0 * Math.pow(t, 2.0) / d;
        double x2 = Math.pow(t, 2.0) / d;
        double y1 = (8.0 - 2.0 * m * Math.pow(t, 2.0)) / d;
        double y2 = (-4.0 - 4.0 * rp * t - m * Math.pow(t, 2.0)) / d;
        double k = 0.0;
        switch (filterType) {
            case HIGH_PASS: {
                k = -Math.cos(0.5 * w + 0.5) / Math.cos(0.5 * w - 0.5);
                break;
            }
            default: {
                k = Math.sin(0.5 - 0.5 * w) / Math.sin(0.5 * w + 0.5);
            }
        }
        d = 1.0 + y1 * k - y2 * Math.pow(k, 2.0);
        double[] filterParameters = new double[5];
        double a0 = (x0 - x1 * k + x2 * Math.pow(k, 2.0)) / d;
        double a1 = (-2.0 * x0 * k + x1 + x1 * Math.pow(k, 2.0) - 2.0 * x2 * k) / d;
        double a2 = (x0 * Math.pow(k, 2.0) - x1 * k + x2) / d;
        double b1 = (2.0 * k + y1 + y1 * Math.pow(k, 2.0) - 2.0 * y2 * k) / d;
        double b2 = (-Math.pow(k, 2.0) - y1 * k + y2) / d;
        if (filterType == FilterType.HIGH_PASS) {
            a1 = -a1;
            b1 = -b1;
        }
        filterParameters[0] = a0;
        filterParameters[1] = a1;
        filterParameters[2] = a2;
        filterParameters[3] = b1;
        filterParameters[4] = b2;
        return filterParameters;
    }

    public static double[] decibel(double[] in) {
        return ArrayMath.decibel(in, in.length);
    }

    public static double[] decibel(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = 20.0 * TMathConstants.Log10(in[i]);
        }
        return ret;
    }

    public static double[] decibelInPlace(double[] in) {
        return ArrayMath.decibelInPlace(in, in.length);
    }

    public static double[] decibelInPlace(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        for (int i = 0; i < length; ++i) {
            in[i] = 20.0 * TMathConstants.Log10(in[i]);
        }
        return in;
    }

    public static double[] divide(double[] in, double divisor) {
        return ArrayMath.divide(in, in.length, divisor);
    }

    public static double[] divide(double[] in, double[] divisor) {
        return ArrayMath.divide(in, divisor, in.length);
    }

    public static double[] divide(double[] in, double[] divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)length, (int)divisor.length);
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = divisor[i] == 0.0 ? Double.NaN : in[i] / divisor[i];
        }
        return ret;
    }

    public static double[] divide(double[] in, int length, double divisor) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        if (divisor == 0.0) {
            return ArrayMath.notANumberInPlace(ret);
        }
        double invDivisor = 1.0 / divisor;
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i] * invDivisor;
        }
        return ret;
    }

    public static double[] divideInPlace(double[] in, double divisor) {
        return ArrayMath.divideInPlace(in, in.length, divisor);
    }

    public static double[] divideInPlace(double[] in, double[] divisor) {
        return ArrayMath.divideInPlace(in, divisor, in.length);
    }

    public static double[] divideInPlace(double[] in, double[] divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)length, (int)divisor.length);
        for (int i = 0; i < length; ++i) {
            if (divisor[i] == 0.0) {
                in[i] = Double.NaN;
                continue;
            }
            int n = i;
            in[n] = in[n] / divisor[i];
        }
        return in;
    }

    public static double[] divideInPlace(double[] in, int length, double divisor) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        if (divisor == 0.0) {
            return ArrayMath.notANumberInPlace(in);
        }
        double invDivisor = 1.0 / divisor;
        int i = 0;
        while (i < in.length) {
            int n = i++;
            in[n] = in[n] * invDivisor;
        }
        return in;
    }

    public static double[] filterSignal(double[] signal, double[] output, double cutoffFraction, int filterOrder, FilterType filterType, double ripplePercent) {
        double[] filteredSignal;
        int i;
        int i2;
        AssertUtils.notNull((String)"signal", (Object)signal);
        double[][] recursionCoefficients = new double[22][2];
        double[] coeffA = new double[22];
        double[] coeffB = new double[22];
        double[] tA = new double[22];
        double[] tB = new double[22];
        coeffA[2] = 1.0;
        coeffB[2] = 1.0;
        for (i2 = 1; i2 < filterOrder / 2; ++i2) {
            int j;
            double[] filterParameters = ArrayMath.calculateFilterParameters(cutoffFraction, filterType, ripplePercent, filterOrder, i2);
            for (j = 0; j < coeffA.length; ++j) {
                tA[j] = coeffA[j];
                tB[j] = coeffB[j];
            }
            for (j = 2; j < coeffA.length; ++j) {
                coeffA[j] = filterParameters[0] * tA[j] + filterParameters[1] * tA[j - 1] + filterParameters[2] * tA[j - 2];
                coeffB[j] = tB[j] - filterParameters[3] * tB[j - 1] - filterParameters[4] * tB[j - 2];
            }
        }
        coeffB[2] = 0.0;
        for (i2 = 0; i2 < 20; ++i2) {
            coeffA[i2] = coeffA[i2 + 2];
            coeffB[i2] = -coeffB[i2 + 2];
        }
        double sA = 0.0;
        double sB = 0.0;
        block7: for (int i3 = 0; i3 < 20; ++i3) {
            switch (filterType) {
                case HIGH_PASS: {
                    sA += coeffA[i3] * Math.pow(-1.0, i3);
                    sB += coeffA[i3] * Math.pow(-1.0, i3);
                    continue block7;
                }
                default: {
                    sA += coeffA[i3];
                    sB += coeffB[i3];
                }
            }
        }
        double gain = sA / (1.0 - sB);
        for (i = 0; i < 20; ++i) {
            coeffA[i] = coeffA[i] / gain;
        }
        for (i = 0; i < 22; ++i) {
            recursionCoefficients[i][0] = coeffA[i];
            recursionCoefficients[i][1] = coeffB[i];
        }
        double[] dArray = filteredSignal = output == null ? new double[signal.length] : output;
        if (output != null) {
            AssertUtils.gtOrEqual((String)"output", (int)signal.length, (int)output.length);
        }
        double filterSampleA = 0.0;
        double filterSampleB = 0.0;
        for (int i4 = filterOrder; i4 < signal.length; ++i4) {
            int j;
            for (j = 0; j < filterOrder + 1; ++j) {
                filterSampleA += coeffA[j] * signal[i4 - j];
            }
            for (j = 1; j < filterOrder + 1; ++j) {
                filterSampleB += coeffB[j] * filteredSignal[i4 - j];
            }
            filteredSignal[i4] = filterSampleA + filterSampleB;
            filterSampleA = 0.0;
            filterSampleB = 0.0;
        }
        return filteredSignal;
    }

    public static double[] inverseDecibel(double[] in) {
        return ArrayMath.inverseDecibel(in, in.length);
    }

    public static double[] inverseDecibel(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = Math.pow(10.0, in[i] / 20.0);
        }
        return ret;
    }

    public static double[] inverseDecibelInPlace(double[] in) {
        return ArrayMath.inverseDecibelInPlace(in, in.length);
    }

    public static double[] inverseDecibelInPlace(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        for (int i = 0; i < length; ++i) {
            in[i] = Math.pow(10.0, in[i] / 20.0);
        }
        return in;
    }

    public static double[] multiply(double[] in, double multiplicator) {
        return ArrayMath.multiply(in, in.length, multiplicator);
    }

    public static double[] multiply(double[] in, double[] multiplicator) {
        return ArrayMath.multiply(in, multiplicator, in.length);
    }

    public static double[] multiply(double[] in, double[] multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)length, (int)multiplicator.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i] * multiplicator[i];
        }
        return ret;
    }

    public static double[] multiply(double[] in, int length, double multiplicator) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i] * multiplicator;
        }
        return ret;
    }

    public static double[] multiplyInPlace(double[] in, double multiplicator) {
        return ArrayMath.multiplyInPlace(in, in.length, multiplicator);
    }

    public static double[] multiplyInPlace(double[] in, double[] multiplicator) {
        return ArrayMath.multiplyInPlace(in, multiplicator, in.length);
    }

    public static double[] multiplyInPlace(double[] in, double[] multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)length, (int)multiplicator.length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            in[n] = in[n] * multiplicator[i];
        }
        return in;
    }

    public static double[] multiplyInPlace(double[] in, int length, double multiplicator) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        int i = 0;
        while (i < in.length) {
            int n = i++;
            in[n] = in[n] * multiplicator;
        }
        return in;
    }

    public static double[] notANumber(double[] in) {
        return ArrayMath.notANumber(in, in.length);
    }

    public static double[] notANumber(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        ArrayUtils.fillArray(ret, 0, length, Double.NaN);
        return ret;
    }

    public static double[] notANumberInPlace(double[] in) {
        return ArrayMath.notANumberInPlace(in, in.length);
    }

    public static double[] notANumberInPlace(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        ArrayUtils.fillArray(in, 0, length, Double.NaN);
        return in;
    }

    public static double[] sqr(double[] in) {
        return ArrayMath.sqr(in, in.length);
    }

    public static double[] sqr(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i] * in[i];
        }
        return ret;
    }

    public static double[] sqrInPlace(double[] in) {
        return ArrayMath.sqrInPlace(in, in.length);
    }

    public static double[] sqrInPlace(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        for (int i = 0; i < length; ++i) {
            in[i] = in[i] * in[i];
        }
        return in;
    }

    public static double[] sqrt(double[] in) {
        return ArrayMath.sqrt(in, in.length);
    }

    public static double[] sqrt(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = TMathConstants.Sqrt(in[i]);
        }
        return ret;
    }

    public static double[] sqrtInPlace(double[] in) {
        return ArrayMath.sqrtInPlace(in, in.length);
    }

    public static double[] sqrtInPlace(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        for (int i = 0; i < length; ++i) {
            in[i] = TMathConstants.Sqrt(in[i]);
        }
        return in;
    }

    public static double[] subtract(double[] in, double value) {
        return ArrayMath.subtract(in, in.length, value);
    }

    public static double[] subtract(double[] in, double[] value) {
        return ArrayMath.subtract(in, value, in.length);
    }

    public static double[] subtract(double[] in, double[] value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)length, (int)value.length);
        double[] ret = new double[length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] - value[i];
        }
        return ret;
    }

    public static double[] subtract(double[] in, int length, double value) {
        AssertUtils.notNull((String)IN, (Object)in);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i] - value;
        }
        return ret;
    }

    public static double[] subtractInPlace(double[] in, double value) {
        return ArrayMath.subtractInPlace(in, in.length, value);
    }

    public static double[] subtractInPlace(double[] in, double[] value) {
        return ArrayMath.subtractInPlace(in, value, in.length);
    }

    public static double[] subtractInPlace(double[] in, double[] value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)length, (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            in[n] = in[n] - value[i];
        }
        return in;
    }

    public static double[] subtractInPlace(double[] in, int length, double value) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        int i = 0;
        while (i < length) {
            int n = i++;
            in[n] = in[n] - value;
        }
        return in;
    }

    public static double[] tenLog10(double[] in) {
        return ArrayMath.tenLog10(in, in.length);
    }

    public static double[] tenLog10(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = 10.0 * TMathConstants.Log10(in[i]);
        }
        return ret;
    }

    public static double[] tenLog10InPlace(double[] in) {
        return ArrayMath.tenLog10InPlace(in, in.length);
    }

    public static double[] tenLog10InPlace(double[] in, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        for (int i = 0; i < length; ++i) {
            in[i] = 10.0 * TMathConstants.Log10(in[i]);
        }
        return in;
    }

    public static enum FilterType {
        LOW_PASS,
        HIGH_PASS;

    }
}

