/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

public class FastMath {
    private static final int DEFAULT_TRIG_RESOLUTION = 3600;
    private static int precision = 3600;
    private static int modulusRad;
    private static int modulusRadQuater;
    private static int modulusDeg;
    private static float[] sinRadLookup;
    private static float[] sinDegLockup;

    private FastMath() {
    }

    public static double cos(double a) {
        return FastMath.sinLocalLookUp((int)(a * (double)precision + (double)modulusRadQuater + 0.5));
    }

    public static float cos(float a) {
        return FastMath.sinLocalLookUp((int)(a * (float)precision + (float)modulusRadQuater + 0.5f));
    }

    public static double cosDeg(double a) {
        return FastMath.sinLocalLookUpDegree((int)((a + 90.0) * (double)precision + 0.5));
    }

    public static float cosDeg(float a) {
        return FastMath.sinLocalLookUpDegree((int)((a + 90.0f) * (float)precision + 0.5f));
    }

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int precision) {
        if (precision <= 0) {
            throw new IllegalArgumentException("precision '" + precision + "'must be positive");
        }
        FastMath.precision = precision;
        FastMath.init();
    }

    public static double sin(double a) {
        return FastMath.sinLocalLookUp((int)(a * (double)precision + 0.5));
    }

    public static float sin(float a) {
        return FastMath.sinLocalLookUp((int)(a * (float)precision + 0.5f));
    }

    public static double sinDeg(double a) {
        return FastMath.sinLocalLookUpDegree((int)(a * (double)precision + 0.5));
    }

    public static float sinDeg(float a) {
        return FastMath.sinLocalLookUpDegree((int)(a * (float)precision + 0.5f));
    }

    private static void init() {
        int i;
        modulusRad = (int)(Math.PI * 2 * (double)precision);
        modulusRadQuater = modulusRad >> 2;
        modulusDeg = 360 * precision;
        sinRadLookup = new float[modulusRad];
        sinDegLockup = new float[modulusDeg];
        for (i = 0; i < modulusRad; ++i) {
            FastMath.sinRadLookup[i] = (float)Math.sin((double)i / (double)precision);
        }
        for (i = 0; i < modulusDeg; ++i) {
            FastMath.sinDegLockup[i] = (float)Math.sin(Math.toRadians((double)i / (double)precision));
        }
    }

    private static float sinLocalLookUp(int a) {
        return a >= 0 ? sinRadLookup[a % modulusRad] : -sinRadLookup[-a % modulusRad];
    }

    private static float sinLocalLookUpDegree(int a) {
        return a >= 0 ? sinDegLockup[a % modulusDeg] : -sinDegLockup[-a % modulusDeg];
    }

    static {
        FastMath.init();
    }
}

