/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.DoubleArrayCache;
import java.util.Arrays;

public final class MultiDimDataSetMath {
    private MultiDimDataSetMath() {
    }

    public static void computeIntegral(DataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax) {
        MultiDimDataSetMath.computeMeanIntegral(source, output, dimIndex, xMin, xMax, false);
    }

    public static void computeMax(DataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax) {
        MultiDimDataSetMath.computeMinMax(source, output, dimIndex, xMin, xMax, false);
    }

    public static void computeMean(DataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax) {
        MultiDimDataSetMath.computeMeanIntegral(source, output, dimIndex, xMin, xMax, true);
    }

    public static void computeMin(DataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax) {
        MultiDimDataSetMath.computeMinMax(source, output, dimIndex, xMin, xMax, true);
    }

    public static void computeSlice(DataSet source, DoubleErrorDataSet output, int dimIndex, double xMin) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(source);
        MultiDimDataSetMath.checkOutputDataSetCompatibility((DataSet)output);
        double[] xValues = output.getValues(0);
        double[] yValues = output.getValues(1);
        double[] yErrorNeg = output.getErrorsNegative(1);
        double[] yErrorPos = output.getErrorsPositive(1);
        if (source.getDataCount(dimIndex) == output.getDataCount(0)) {
            int nsize = source.getDataCount(dimIndex);
            System.arraycopy(source.getValues(dimIndex), 0, xValues, 0, nsize);
            double[] ret = MultiDimDataSetMath.getSliceArray(source, dimIndex, xMin, yValues);
            output.set(xValues, ret, yErrorNeg, yErrorPos, false);
        } else {
            int nsize = source.getDataCount(dimIndex);
            double[] ret = MultiDimDataSetMath.getSliceArray(source, dimIndex, xMin, yValues);
            output.set(Arrays.copyOf(source.getValues(dimIndex), nsize), ret, new double[nsize], new double[nsize], false);
        }
        output.setName("slice(" + source.getName() + ")@" + xMin + " " + source.getAxisDescription(dimIndex).getUnit());
        output.getAxisDescription(0).set(source.getAxisDescription(dimIndex).getName(), new String[]{source.getAxisDescription(dimIndex).getUnit()});
        output.getAxisDescription(1).set(source.getAxisDescription(2).getName(), new String[]{source.getAxisDescription(2).getUnit()});
        output.getAxisDescriptions().stream().forEach(AxisDescription::clear);
    }

    public static double[] getMeanIntegralArray(DataSet source, int dimIndex, double xMin, double xMax, double[] buffer, boolean isMean) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(source);
        double[] ret = MultiDimDataSetMath.getSanitizedBuffer(source, dimIndex, buffer);
        int minIndex = source.getIndex(dimIndex == 0 ? 1 : 0, xMin);
        int maxIndex = source.getIndex(dimIndex == 0 ? 1 : 0, xMax);
        int min = Math.min(minIndex, maxIndex);
        int max = Math.max(Math.max(minIndex, maxIndex), min + 1);
        int nDataCount = source.getDataCount(dimIndex);
        int rowSize = source.getDataCount(0);
        if (dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double integral = 0.0;
                int nSlices = 0;
                for (int i = min; i <= Math.min(max, nDataCount - 1); ++i) {
                    integral += source.get(2, i + index * rowSize);
                    ++nSlices;
                }
                ret[index] = isMean ? (nSlices == 0 ? Double.NaN : integral / (double)nSlices) : integral;
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double integral = 0.0;
                int nSlices = 0;
                for (int i = min; i <= Math.min(max, nDataCount - 1); ++i) {
                    integral += source.get(2, index + i * rowSize);
                    ++nSlices;
                }
                ret[index] = isMean ? (nSlices == 0 ? Double.NaN : integral / (double)nSlices) : integral;
            }
        }
        return ret;
    }

    public static double[] getMinMaxArray(DataSet source, int dimIndex, double xMin, double xMax, double[] buffer, boolean isMin) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(source);
        double[] ret = MultiDimDataSetMath.getSanitizedBuffer(source, dimIndex, buffer);
        int minIndex = source.getIndex(dimIndex == 0 ? 1 : 0, xMin);
        int maxIndex = source.getIndex(dimIndex == 0 ? 1 : 0, xMax);
        int min = Math.min(minIndex, maxIndex);
        int max = Math.max(Math.max(minIndex, maxIndex), min + 1);
        int nDataCount = source.getDataCount(dimIndex);
        int rowSize = source.getDataCount(0);
        if (dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double extreme = source.get(2, min + index * rowSize);
                for (int i = min + 1; i <= Math.min(max, nDataCount - 1); ++i) {
                    double val = source.get(2, i + index * rowSize);
                    extreme = isMin ? Math.min(val, extreme) : Math.max(val, extreme);
                }
                ret[index] = extreme;
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double extreme = source.get(2, index + min * rowSize);
                for (int i = min + 1; i <= Math.min(max, nDataCount - 1); ++i) {
                    double val = source.get(2, index + i * rowSize);
                    extreme = isMin ? Math.min(val, extreme) : Math.max(val, extreme);
                }
                ret[index] = extreme;
            }
        }
        return ret;
    }

    public static double[] getSliceArray(DataSet source, int dimIndex, double xMin, double[] buffer) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(source);
        double[] ret = MultiDimDataSetMath.getSanitizedBuffer(source, dimIndex, buffer);
        int minIndex = source.getIndex(dimIndex == 0 ? 1 : 0, xMin);
        int nDataCount = source.getDataCount(dimIndex);
        int rowSize = source.getDataCount(0);
        if (dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double y;
                ret[index] = y = source.get(2, minIndex + index * rowSize);
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double y;
                ret[index] = y = source.get(2, index + minIndex * rowSize);
            }
        }
        return ret;
    }

    private static void checkMultiDimDataSetCompatibility(DataSet source) {
        if (source == null || source.getDimension() <= 2) {
            throw new IllegalArgumentException("source is " + (source == null ? "null" : " has insufficient dimension = " + source.getDimension()));
        }
    }

    private static void checkOutputDataSetCompatibility(DataSet ouput) {
        if (ouput == null || ouput.getDimension() != 2) {
            throw new IllegalArgumentException("output is " + (ouput == null ? "null" : " has insufficient dimension = " + ouput.getDimension()));
        }
    }

    private static void computeMeanIntegral(DataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, boolean isMean) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(source);
        MultiDimDataSetMath.checkOutputDataSetCompatibility((DataSet)output);
        double[] xValues = output.getValues(0);
        double[] yValues = output.getValues(1);
        double[] yErrorNeg = output.getErrorsNegative(1);
        double[] yErrorPos = output.getErrorsPositive(1);
        if (source.getDataCount(dimIndex) == output.getDataCount(0)) {
            int nsize = source.getDataCount(dimIndex);
            System.arraycopy(source.getValues(dimIndex), 0, xValues, 0, nsize);
            double[] ret = MultiDimDataSetMath.getMeanIntegralArray(source, dimIndex, xMin, xMax, yValues, isMean);
            output.set(xValues, ret, yErrorNeg, yErrorPos, false);
        } else {
            int nsize = source.getDataCount(dimIndex);
            double[] ret = MultiDimDataSetMath.getMeanIntegralArray(source, dimIndex, xMin, xMax, yValues, isMean);
            output.set(Arrays.copyOf(source.getValues(dimIndex), nsize), ret, new double[nsize], new double[nsize], false);
        }
        output.setName((isMean ? "mean(" : "int(") + source.getName() + ")@" + xMin + " -> " + xMax + " " + source.getAxisDescription(dimIndex).getUnit());
        output.getAxisDescription(0).set(source.getAxisDescription(dimIndex).getName(), new String[]{source.getAxisDescription(dimIndex).getUnit()});
        output.getAxisDescription(1).set(source.getAxisDescription(2).getName(), new String[]{source.getAxisDescription(2).getUnit()});
        output.getAxisDescriptions().stream().forEach(AxisDescription::clear);
    }

    private static void computeMinMax(DataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, boolean isMin) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility(source);
        MultiDimDataSetMath.checkOutputDataSetCompatibility((DataSet)output);
        double[] xValues = output.getValues(0);
        double[] yValues = output.getValues(1);
        double[] yErrorNeg = output.getErrorsNegative(1);
        double[] yErrorPos = output.getErrorsPositive(1);
        if (source.getDataCount(dimIndex) == output.getDataCount(0)) {
            int nsize = source.getDataCount(dimIndex);
            System.arraycopy(source.getValues(dimIndex), 0, xValues, 0, nsize);
            double[] ret = MultiDimDataSetMath.getMinMaxArray(source, dimIndex, xMin, xMax, yValues, isMin);
            output.set(xValues, ret, yErrorNeg, yErrorPos, false);
        } else {
            int nsize = source.getDataCount(dimIndex);
            double[] ret = MultiDimDataSetMath.getMinMaxArray(source, dimIndex, xMin, xMax, yValues, isMin);
            output.set(Arrays.copyOf(source.getValues(dimIndex), nsize), ret, new double[nsize], new double[nsize], false);
        }
        output.setName((isMin ? "min(" : "max(") + source.getName() + ")@" + xMin + " -> " + xMax + " " + source.getAxisDescription(dimIndex).getUnit());
        output.getAxisDescription(0).set(source.getAxisDescription(dimIndex).getName(), new String[]{source.getAxisDescription(dimIndex).getUnit()});
        output.getAxisDescription(1).set(source.getAxisDescription(2).getName(), new String[]{source.getAxisDescription(2).getUnit()});
        output.getAxisDescriptions().stream().forEach(AxisDescription::clear);
    }

    private static double[] getSanitizedBuffer(DataSet source, int dimIndex, double[] buffer) {
        int size = source.getDataCount(dimIndex == 0 ? 0 : 1);
        boolean invalidBUffer = buffer == null || buffer.length < size;
        double[] ret = invalidBUffer ? DoubleArrayCache.getInstance().getArrayExact(size) : buffer;
        return ret;
    }
}

