/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

public class TMathConstants {
    double ACosH(double arg0) {
        if (arg0 == 0.0) {
            return 0.0;
        }
        double ax = Math.abs(arg0);
        return Math.log(arg0 + ax * Math.sqrt(1.0 - 1.0 / (ax * ax)));
    }

    double ASinH(double arg0) {
        if (arg0 == 0.0) {
            return 0.0;
        }
        double ax = Math.abs(arg0);
        return Math.log(arg0 + ax * Math.sqrt(1.0 + 1.0 / (ax * ax)));
    }

    double ATanH(double arg0) {
        return Math.log((1.0 + arg0) / (1.0 - arg0)) / 2.0;
    }

    public double Hypot(double x, double y) {
        return Math.hypot(x, y);
    }

    public static double Abs(double d) {
        return d >= 0.0 ? d : -d;
    }

    public static float Abs(float d) {
        return d >= 0.0f ? d : -d;
    }

    public static int Abs(int d) {
        return d >= 0 ? d : -d;
    }

    public static long Abs(long d) {
        return d >= 0L ? d : -d;
    }

    public static short Abs(short d) {
        return d >= 0 ? d : (short)(-d);
    }

    public static double ACos(double arg0) {
        return Math.acos(arg0);
    }

    public static double ASin(double arg0) {
        return Math.asin(arg0);
    }

    public static double ATan(double arg0) {
        return Math.atan(arg0);
    }

    public static double ATan2(double y, double x) {
        if (x != 0.0) {
            return Math.atan2(y, x);
        }
        if (y == 0.0) {
            return 0.0;
        }
        if (y > 0.0) {
            return TMathConstants.Pi() / 2.0;
        }
        return -TMathConstants.Pi() / 2.0;
    }

    public static final double C() {
        return 2.99792458E8;
    }

    public static final double Ccgs() {
        return 100.0 * TMathConstants.C();
    }

    public static final double Ceil(double x) {
        return Math.ceil(x);
    }

    public static final int CeilNint(double x) {
        return TMathConstants.Nint(Math.ceil(x));
    }

    public static double Cos(double arg0) {
        return Math.cos(arg0);
    }

    public static double CosH(double arg0) {
        return Math.cosh(arg0);
    }

    public static final double CUncertainty() {
        return 0.0;
    }

    public static final double DegToRad() {
        return TMathConstants.Pi() / 180.0;
    }

    public static final double E() {
        return Math.E;
    }

    public static final double EulerGamma() {
        return 0.5772156649015329;
    }

    public static boolean Even(long a) {
        return (a & 1L) == 0L;
    }

    public static double Exp(double x) {
        return Math.exp(x);
    }

    public static boolean Finite(double x) {
        return !Double.isInfinite(x) && !Double.isNaN(x);
    }

    public static double Floor(double x) {
        return Math.floor(x);
    }

    public static int FloorNint(double x) {
        return TMathConstants.Nint(Math.floor(x));
    }

    public static final double G() {
        return 6.673E-11;
    }

    public static final double Gcgs() {
        return TMathConstants.G() / 1000.0;
    }

    public static final double GhbarC() {
        return 6.707E-39;
    }

    public static final double GhbarCUncertainty() {
        return 1.0E-41;
    }

    public static final double Gn() {
        return 9.80665;
    }

    public static final double GnUncertainty() {
        return 0.0;
    }

    public static final double GUncertainty() {
        return 1.0E-13;
    }

    public static final double H() {
        return 6.62606876E-34;
    }

    public static final double Hbar() {
        return 1.054571596E-34;
    }

    public static final double Hbarcgs() {
        return 1.0E7 * TMathConstants.Hbar();
    }

    public static final double HbarUncertainty() {
        return 8.2E-42;
    }

    public static final double HC() {
        return TMathConstants.H() * TMathConstants.C();
    }

    public static final double HCcgs() {
        return TMathConstants.Hcgs() * TMathConstants.Ccgs();
    }

    public static final double Hcgs() {
        return 1.0E7 * TMathConstants.H();
    }

    public static final double HUncertainty() {
        return 5.2E-41;
    }

    public static long Hypot(long x, long y) {
        return (long)Math.hypot(x, y);
    }

    public static final double InvPi() {
        return 1.0 / TMathConstants.Pi();
    }

    public static boolean IsNaN(double x) {
        return Double.isNaN(x);
    }

    public static final double K() {
        return 1.3806503E-23;
    }

    public static final double Kcgs() {
        return 1.0E7 * TMathConstants.K();
    }

    public static final double KUncertainty() {
        return 2.4E-29;
    }

    public static double Ldexp(double x, int exp) {
        return x * Math.pow(2.0, exp);
    }

    public static final double Ln10() {
        return 2.302585092994046;
    }

    public static double Log(double x) {
        return Math.log(x);
    }

    public static double Log10(double x) {
        return Math.log10(x);
    }

    public static final double Log2() {
        return 0.201029996;
    }

    public static double Log2(double x) {
        return Math.log(x) / TMathConstants.Log2();
    }

    public static final double LogE() {
        return 0.4342944819032518;
    }

    public static double Max(double a, double b) {
        return a >= b ? a : b;
    }

    public static float Max(float a, float b) {
        return a >= b ? a : b;
    }

    public static int Max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long Max(long a, long b) {
        return a >= b ? a : b;
    }

    public static short Max(short a, short b) {
        return a >= b ? a : b;
    }

    public static double Min(double a, double b) {
        return a <= b ? a : b;
    }

    public static float Min(float a, float b) {
        return a <= b ? a : b;
    }

    public static int Min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long Min(long a, long b) {
        return a <= b ? a : b;
    }

    public static short Min(short a, short b) {
        return a <= b ? a : b;
    }

    public static final double MWair() {
        return 28.9644;
    }

    public static final double Na() {
        return 6.02214199E23;
    }

    public static final double NaUncertainty() {
        return 4.7E16;
    }

    public static long NextPrime(long x) {
        if (x <= 2L) {
            return 2L;
        }
        if (x == 3L) {
            return 3L;
        }
        if (x % 2L == 0L) {
            ++x;
        }
        long sqr = (long)Math.sqrt(x) + 1L;
        while (true) {
            long n;
            for (n = 3L; n <= sqr && x % n != 0L; n += 2L) {
            }
            if (n > sqr) {
                return x;
            }
            x += 2L;
        }
    }

    public static int Nint(double x) {
        int i;
        if (x >= 0.0) {
            i = (int)(x + 0.5);
            if (x + 0.5 == (double)i && (i & 1) > 0) {
                --i;
            }
        } else {
            i = (int)(x - 0.5);
            if (x - 0.5 == (double)i && (i & 1) > 0) {
                ++i;
            }
        }
        return i;
    }

    public static int Nint(float x) {
        int i;
        if (x >= 0.0f) {
            i = (int)(x + 0.5f);
            if (x + 0.5f == (float)i && (i & 1) > 0) {
                --i;
            }
        } else {
            i = (int)((double)x - 0.5);
            if (x - 0.5f == (float)i && (i & 1) > 0) {
                ++i;
            }
        }
        return i;
    }

    public static boolean Odd(long a) {
        return (a & 1L) != 0L;
    }

    public static final double Pi() {
        return Math.PI;
    }

    public static final double PiOver2() {
        return TMathConstants.Pi() / 2.0;
    }

    public static final double PiOver4() {
        return TMathConstants.Pi() / 4.0;
    }

    public static double Power(double x, double y) {
        return Math.pow(x, y);
    }

    public static final double Qe() {
        return 1.602176462E-19;
    }

    public static final double QeUncertainty() {
        return 6.3E-27;
    }

    public static final double R() {
        return TMathConstants.K() * TMathConstants.Na();
    }

    public static final double RadToDeg() {
        return 180.0 / TMathConstants.Pi();
    }

    public static double Range(double lb, double ub, double x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static int Range(int lb, int ub, int x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static long Range(long lb, long ub, long x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static short Range(short lb, short ub, short x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static final double Rgair() {
        return 1000.0 * TMathConstants.R() / TMathConstants.MWair();
    }

    public static final double RUncertainty() {
        return TMathConstants.R() * (TMathConstants.KUncertainty() / TMathConstants.K() + TMathConstants.NaUncertainty() / TMathConstants.Na());
    }

    public static final double Sigma() {
        return 5.6704E-8;
    }

    public static final double SigmaUncertainty() {
        return 4.0E-13;
    }

    public static double Sign(double a, double b) {
        return b >= 0.0 ? TMathConstants.Abs(a) : -TMathConstants.Abs(a);
    }

    public static float Sign(float a, float b) {
        return b >= 0.0f ? TMathConstants.Abs(a) : -TMathConstants.Abs(a);
    }

    public static int Sign(int a, int b) {
        return b >= 0 ? TMathConstants.Abs(a) : -TMathConstants.Abs(a);
    }

    public static long Sign(long a, long b) {
        return b >= 0L ? TMathConstants.Abs(a) : -TMathConstants.Abs(a);
    }

    public static short Sign(short a, short b) {
        return b >= 0 ? TMathConstants.Abs(a) : (short)(-TMathConstants.Abs(a));
    }

    public static double Sin(double arg0) {
        return Math.sin(arg0);
    }

    public static double SinH(double arg0) {
        return Math.sinh(arg0);
    }

    public static double Sqr(double x) {
        return x * x;
    }

    public static double Sqrt(double x) {
        return Math.sqrt(x);
    }

    public static final double Sqrt2() {
        return 1.4142135623730951;
    }

    public static double Tan(double arg0) {
        return Math.tan(arg0);
    }

    public static double TanH(double arg0) {
        return Math.tanh(arg0);
    }

    public static final double TwoPi() {
        return 2.0 * TMathConstants.Pi();
    }
}

