/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.math.TMath;
import de.gsi.math.functions.AbstractFunction1D;
import de.gsi.math.functions.Function1D;

public class BreitWignerFunction
extends AbstractFunction1D
implements Function1D {
    public BreitWignerFunction(String name) {
        this(name, null);
    }

    public BreitWignerFunction(String name, double[] parameter) {
        super(name, new double[2]);
        this.setParameterName(0, "mean");
        this.setParameterValue(0, 0.0);
        this.setParameterName(1, "gamma");
        this.setParameterValue(1, 1.0);
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < Math.min(parameter.length, 2); ++i) {
            this.setParameterValue(i, parameter[i]);
        }
    }

    @Override
    public double getValue(double x) {
        return TMath.BreitWigner(x, this.fparameter[0], this.fparameter[1]);
    }
}

