/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.math.TMath;
import de.gsi.math.functions.AbstractFunction1D;
import de.gsi.math.functions.Function1D;

public class TrigSineFunction
extends AbstractFunction1D
implements Function1D {
    public TrigSineFunction(String name) {
        this(name, null);
    }

    public TrigSineFunction(String name, double[] parameter) {
        super(name, new double[3]);
        this.setParameterName(0, "amplitude");
        this.setParameterValue(0, 1.0);
        this.setParameterName(1, "frequency");
        this.setParameterValue(1, 1.0);
        this.setParameterName(2, "phase");
        this.setParameterValue(2, 1.0);
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < Math.min(parameter.length, 3); ++i) {
            this.setParameterValue(i, parameter[i]);
        }
    }

    @Override
    public double getValue(double x) {
        return this.fparameter[0] * TMath.Sin(TMath.TwoPi() * (this.fparameter[1] * x + this.fparameter[2]));
    }
}

