/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.spi.MultiDimDoubleDataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.DoubleArrayCache;
import de.gsi.math.spectra.Apodization;
import de.gsi.math.spectra.SpectrumTools;
import java.util.Arrays;
import org.jtransforms.fft.DoubleFFT_1D;

public class ShortTimeFourierTransform {
    protected static void apodizeComplex(double[] data, Apodization apodization) {
        double[] window = apodization.getWindow(data.length / 2);
        for (int i = 0; i < data.length / 2; ++i) {
            data[2 * i] = data[2 * i] * window[i];
            data[2 * i + 1] = data[2 * i + 1] * window[i];
        }
    }

    private static int ceilDiv(int a, int b) {
        return (a + b - 1) / b;
    }

    public static DataSet complex(DataSet input, DataSet output, int nFFT, int step, Apodization apodization, Padding padding, boolean dbScale, boolean truncateDCNy) {
        AssertUtils.notNull((String)"input", (Object)input);
        AssertUtils.gtThanZero((String)"nFFT", (int)nFFT);
        AssertUtils.gtThanZero((String)"step", (int)step);
        AssertUtils.notNull((String)"apodization", (Object)((Object)apodization));
        AssertUtils.notNull((String)"padding", (Object)((Object)padding));
        AssertUtils.gtOrEqual((String)"input.getDimension()", (int)3, (int)input.getDimension());
        if (input.getDataCount(0) != input.getDataCount(1) || input.getDataCount(0) != input.getDataCount(2)) {
            throw new IllegalArgumentException("The first 3 dimensions must have equal number of points");
        }
        if (input.getDataCount() == 0) {
            if (output instanceof MultiDimDoubleDataSet) {
                ((MultiDimDoubleDataSet)output).clearData();
                ((MultiDimDoubleDataSet)output).clearMetaInfo();
                return output;
            }
            return new DataSetBuilder("STFT(" + input.getName() + ")").setInitalCapacity(new int[]{0}).setDimension(3).build();
        }
        int nSamples = input.getDataCount();
        double dt = (input.get(0, nSamples - 1) - input.get(0, 0)) / (double)nSamples;
        double[] real = input.getValues(1);
        double[] imag = input.getValues(2);
        double[] oldTimeAxis = output == null ? null : output.getValues(0);
        double[] timeAxis = ShortTimeFourierTransform.getTimeAxis(dt, nSamples, step, oldTimeAxis);
        double[] oldFrequencyAxis = output == null ? null : output.getValues(1);
        double[] frequencyAxis = ShortTimeFourierTransform.getFrequencyAxisComplex(dt, nFFT, oldFrequencyAxis);
        double[] oldAmplitudeData = output instanceof MultiDimDoubleDataSet ? ((MultiDimDoubleDataSet)output).getValues(2) : null;
        double[] amplitudeData = ShortTimeFourierTransform.complex(real, imag, oldAmplitudeData, nFFT, step, apodization, padding, dbScale, truncateDCNy);
        MultiDimDoubleDataSet result = output instanceof MultiDimDoubleDataSet ? (MultiDimDoubleDataSet)output : (MultiDimDoubleDataSet)new DataSetBuilder("STFT(" + input.getName() + ")").setValues(0, frequencyAxis).setValues(1, timeAxis).setValues(2, amplitudeData).build();
        result.lock().writeLockGuard(() -> {
            if (oldTimeAxis != timeAxis) {
                result.setValues(0, frequencyAxis, false);
            }
            if (oldFrequencyAxis != frequencyAxis) {
                result.setValues(1, timeAxis, false);
            }
            if (oldAmplitudeData != amplitudeData) {
                result.setValues(2, amplitudeData, false);
            }
            result.getMetaInfo().put("ComplexSTFT-nFFT", Integer.toString(nFFT));
            result.getMetaInfo().put("ComplexSTFT-step", Integer.toString(step));
            String timeUnit = input.getAxisDescription(0).getUnit();
            String freqUnit = timeUnit.equals("s") ? "Hz" : "1/" + timeUnit;
            result.getAxisDescription(0).set("Frequency", freqUnit, frequencyAxis[0], frequencyAxis[frequencyAxis.length - 1]);
            result.getAxisDescription(1).set("Time", timeUnit, timeAxis[0], timeAxis[timeAxis.length - 1]);
            result.getAxisDescription(2).set("Magnitude", new String[]{input.getAxisDescription(1).getUnit()});
            result.recomputeLimits(2);
        });
        return result;
    }

    public static double[] complex(double[] real, double[] imag, double[] output, int nFFT, int step, Apodization apodization, Padding padding, boolean dbScale, boolean truncateDCNy) {
        AssertUtils.equalDoubleArrays((double[])real, (double[])imag);
        int nT = ShortTimeFourierTransform.ceilDiv(real.length, step);
        double[] amplitudeData = output == null || output.length != nFFT * nT ? new double[nFFT * nT] : output;
        double[] currentMagnitudeData = DoubleArrayCache.getInstance().getArray(nFFT);
        DoubleFFT_1D fastFourierTrafo = new DoubleFFT_1D((long)nFFT);
        double[] raw = DoubleArrayCache.getInstance().getArrayExact(2 * nFFT);
        for (int i = 0; i < nT; ++i) {
            int offset = i * step;
            int validLength = real.length - offset;
            block5: for (int j = 0; j < nFFT; ++j) {
                if (offset + j < real.length) {
                    raw[2 * j] = real[offset + j];
                    raw[2 * j + 1] = imag[offset + j];
                    continue;
                }
                switch (padding) {
                    case MIRROR: {
                        raw[2 * j] = real[real.length - j + validLength - 1];
                        raw[2 * j + 1] = imag[imag.length - j + validLength - 1];
                        continue block5;
                    }
                    case ZERO: {
                        Arrays.fill(raw, 2 * j, 2 * nFFT, 0.0);
                        break block5;
                    }
                    default: {
                        raw[2 * j] = real[real.length - 1];
                        raw[2 * j + 1] = imag[imag.length - 1];
                    }
                }
            }
            ShortTimeFourierTransform.apodizeComplex(raw, apodization);
            fastFourierTrafo.complexForward(raw);
            if (dbScale) {
                SpectrumTools.computeMagnitudeSpectrum_dB(raw, 0, 2 * nFFT, currentMagnitudeData, 0, truncateDCNy);
            } else {
                SpectrumTools.computeMagnitudeSpectrum(raw, 0, 2 * nFFT, currentMagnitudeData, 0, truncateDCNy);
            }
            System.arraycopy(currentMagnitudeData, 0, amplitudeData, i * nFFT + nFFT / 2, nFFT / 2);
            System.arraycopy(currentMagnitudeData, nFFT / 2, amplitudeData, i * nFFT, nFFT / 2);
        }
        DoubleArrayCache.getInstance().add((Object)currentMagnitudeData);
        DoubleArrayCache.getInstance().add((Object)raw);
        return amplitudeData;
    }

    public static double[] complex(double[] complexInput, double[] output, int nFFT, int step, Apodization apodization, Padding padding, boolean dbScale, boolean truncateDCNy) {
        int nT = ShortTimeFourierTransform.ceilDiv(complexInput.length, 2 * step);
        double[] amplitudeData = output == null || output.length != nFFT * nT ? new double[nFFT * nT] : output;
        double[] currentMagnitudeData = DoubleArrayCache.getInstance().getArray(nFFT);
        DoubleFFT_1D fastFourierTrafo = new DoubleFFT_1D((long)nFFT);
        double[] raw = DoubleArrayCache.getInstance().getArrayExact(2 * nFFT);
        for (int i = 0; i < nT; ++i) {
            int offset = i * 2 * step;
            int validLength = complexInput.length - offset;
            if (validLength >= 2 * nFFT) {
                System.arraycopy(complexInput, offset, raw, 0, 2 * nFFT);
            } else {
                System.arraycopy(complexInput, offset, raw, 0, validLength);
                switch (padding) {
                    case MIRROR: {
                        int j = validLength;
                        while (j + 1 < raw.length) {
                            raw[j] = complexInput[complexInput.length - j + validLength - 2];
                            raw[j + 1] = complexInput[complexInput.length - j + validLength - 1];
                            j += 2;
                        }
                        break;
                    }
                    case ZERO: {
                        Arrays.fill(raw, validLength, raw.length, 0.0);
                        break;
                    }
                    default: {
                        int j = validLength;
                        while (j + 1 < raw.length) {
                            raw[j] = complexInput[complexInput.length - 2];
                            raw[j + 1] = complexInput[complexInput.length - 1];
                            j += 2;
                        }
                        break block0;
                    }
                }
            }
            ShortTimeFourierTransform.apodizeComplex(raw, apodization);
            fastFourierTrafo.complexForward(raw);
            if (dbScale) {
                SpectrumTools.computeMagnitudeSpectrum_dB(raw, 0, 2 * nFFT, currentMagnitudeData, 0, truncateDCNy);
            } else {
                SpectrumTools.computeMagnitudeSpectrum(raw, 0, 2 * nFFT, currentMagnitudeData, 0, truncateDCNy);
            }
            System.arraycopy(currentMagnitudeData, 0, amplitudeData, i * nFFT + nFFT / 2, nFFT / 2);
            System.arraycopy(currentMagnitudeData, nFFT / 2, amplitudeData, i * nFFT, nFFT / 2);
        }
        DoubleArrayCache.getInstance().add((Object)currentMagnitudeData);
        DoubleArrayCache.getInstance().add((Object)raw);
        return amplitudeData;
    }

    public static double[] getFrequencyAxisComplex(double dt, int nFFT, double[] output) {
        double fStep = 1.0 / dt / (double)nFFT;
        double[] frequencyAxis = output == null || output.length != nFFT ? new double[nFFT] : output;
        for (int i = -nFFT / 2; i < nFFT / 2; ++i) {
            frequencyAxis[i + nFFT / 2] = (double)i * fStep;
        }
        return frequencyAxis;
    }

    public static double[] getFrequencyAxisReal(double dt, int nFFT, double[] output) {
        double fStep = 1.0 / dt / (double)nFFT;
        double[] frequencyAxis = output == null || output.length != nFFT / 2 ? new double[nFFT / 2] : output;
        for (int i = 0; i < nFFT / 2; ++i) {
            frequencyAxis[i] = (double)i * fStep;
        }
        return frequencyAxis;
    }

    public static double[] getTimeAxis(double dt, int nSamples, int step, double[] output) {
        int nT = ShortTimeFourierTransform.ceilDiv(nSamples, step);
        double[] timeAxis = output == null || output.length != nT ? new double[nT] : output;
        for (int i = 0; i < timeAxis.length; ++i) {
            timeAxis[i] = dt * (double)i * (double)step;
        }
        return timeAxis;
    }

    public static DataSet real(DataSet input, DataSet output, int nFFT, int step, Apodization apodization, Padding padding, boolean dbScale, boolean truncateDCNy) {
        AssertUtils.notNull((String)"input", (Object)input);
        AssertUtils.gtThanZero((String)"nFFT", (int)nFFT);
        AssertUtils.gtThanZero((String)"step", (int)step);
        AssertUtils.notNull((String)"apodization", (Object)((Object)apodization));
        AssertUtils.notNull((String)"padding", (Object)((Object)padding));
        AssertUtils.gtOrEqual((String)"input.getDimension()", (int)2, (int)input.getDimension());
        if (input.getDataCount(0) != input.getDataCount(1)) {
            throw new IllegalArgumentException("The X and Y dimensions must have equal number of points");
        }
        if (input.getDataCount() == 0) {
            if (output instanceof MultiDimDoubleDataSet) {
                ((MultiDimDoubleDataSet)output).clearData();
                ((MultiDimDoubleDataSet)output).clearMetaInfo();
                return output;
            }
            return new DataSetBuilder("STFT(" + input.getName() + ")").setInitalCapacity(new int[]{0}).setDimension(3).build();
        }
        int nSamples = input.getDataCount();
        double dt = (input.get(0, nSamples - 1) - input.get(0, 0)) / (double)nSamples;
        double[] yData = input.getValues(1);
        double[] oldTimeAxis = output == null ? null : output.getValues(0);
        double[] timeAxis = ShortTimeFourierTransform.getTimeAxis(dt, nSamples, step, oldTimeAxis);
        double[] oldFrequencyAxis = output == null ? null : output.getValues(1);
        double[] frequencyAxis = ShortTimeFourierTransform.getFrequencyAxisReal(dt, nFFT, oldFrequencyAxis);
        double[] oldAmplitudeData = output instanceof MultiDimDoubleDataSet ? ((MultiDimDoubleDataSet)output).getValues(2) : null;
        double[] amplitudeData = ShortTimeFourierTransform.real(yData, oldAmplitudeData, nFFT, step, apodization, padding, dbScale, truncateDCNy);
        MultiDimDoubleDataSet result = output instanceof MultiDimDoubleDataSet ? (MultiDimDoubleDataSet)output : (MultiDimDoubleDataSet)new DataSetBuilder("STFT(" + input.getName() + ")").setValues(0, frequencyAxis).setValues(1, timeAxis).setValues(2, amplitudeData).build();
        result.lock().writeLockGuard(() -> {
            if (oldFrequencyAxis != frequencyAxis) {
                result.setValues(0, frequencyAxis, false);
            }
            if (oldTimeAxis != timeAxis) {
                result.setValues(1, timeAxis, false);
            }
            if (oldAmplitudeData != amplitudeData) {
                result.setValues(2, amplitudeData, false);
            }
            result.getMetaInfo().put("RealSTFT-nFFT", Integer.toString(nFFT));
            result.getMetaInfo().put("RealSTFT-step", Integer.toString(step));
            String timeUnit = input.getAxisDescription(0).getUnit();
            String freqUnit = timeUnit.equals("s") ? "Hz" : "1/" + timeUnit;
            result.getAxisDescription(0).set("Frequency", freqUnit, frequencyAxis[0], frequencyAxis[frequencyAxis.length - 1]);
            result.getAxisDescription(1).set("Time", timeUnit, timeAxis[0], timeAxis[timeAxis.length - 1]);
            result.getAxisDescription(2).set("Magnitude", new String[]{input.getAxisDescription(1).getUnit()});
            result.recomputeLimits(2);
        });
        return result;
    }

    public static double[] real(double[] input, double[] output, int nFFT, int step, Apodization apodization, Padding padding, boolean dbScale, boolean truncateDCNy) {
        int nT = ShortTimeFourierTransform.ceilDiv(input.length, step);
        double[] amplitudeData = output == null || output.length != nFFT / 2 * nT ? new double[nFFT / 2 * nT] : output;
        double[] currentMagnitudeData = DoubleArrayCache.getInstance().getArray(nFFT / 2);
        DoubleFFT_1D fastFourierTrafo = new DoubleFFT_1D((long)nFFT);
        double[] raw = DoubleArrayCache.getInstance().getArrayExact(nFFT);
        for (int i = 0; i < nT; ++i) {
            int offset = i * step;
            int validLength = input.length - offset;
            if (validLength >= nFFT) {
                System.arraycopy(input, offset, raw, 0, nFFT);
            } else {
                System.arraycopy(input, offset, raw, 0, validLength);
                switch (padding) {
                    case MIRROR: {
                        for (int j = validLength; j < raw.length; ++j) {
                            raw[j] = input[input.length - j + validLength - 1];
                        }
                        break;
                    }
                    case ZERO: {
                        Arrays.fill(raw, validLength, raw.length, 0.0);
                        break;
                    }
                    default: {
                        Arrays.fill(raw, validLength, raw.length, input[input.length - 1]);
                    }
                }
            }
            apodization.apodize(raw);
            fastFourierTrafo.realForward(raw);
            if (dbScale) {
                SpectrumTools.computeMagnitudeSpectrum_dB(raw, 0, nFFT, currentMagnitudeData, 0, truncateDCNy);
            } else {
                SpectrumTools.computeMagnitudeSpectrum(raw, 0, nFFT, currentMagnitudeData, 0, truncateDCNy);
            }
            System.arraycopy(currentMagnitudeData, 0, amplitudeData, i * nFFT / 2, nFFT / 2);
        }
        DoubleArrayCache.getInstance().add((Object)currentMagnitudeData);
        DoubleArrayCache.getInstance().add((Object)raw);
        return amplitudeData;
    }

    public static enum Padding {
        ZERO,
        ZOH,
        MIRROR;

    }
}

