/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.fft;

import org.apache.commons.math3.complex.Complex;

public class ComplexFFT_1D {
    private static Complex[][] coef;
    private static int coef_order;

    public static Complex[] cconvolve(Complex[] x, Complex[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int N = x.length;
        Complex[] a = ComplexFFT_1D.fft(x);
        Complex[] b = ComplexFFT_1D.fft(y);
        Complex[] c = new Complex[N];
        for (int i = 0; i < N; ++i) {
            c[i] = a[i].multiply(b[i]);
        }
        return ComplexFFT_1D.ifft(c);
    }

    public static Complex[] convolve(Complex[] x, Complex[] y) {
        int i;
        int i2;
        Complex ZERO = new Complex(0.0, 0.0);
        Complex[] a = new Complex[2 * x.length];
        for (i2 = 0; i2 < x.length; ++i2) {
            a[i2] = x[i2];
        }
        for (i2 = x.length; i2 < 2 * x.length; ++i2) {
            a[i2] = ZERO;
        }
        Complex[] b = new Complex[2 * y.length];
        for (i = 0; i < y.length; ++i) {
            b[i] = y[i];
        }
        for (i = y.length; i < 2 * y.length; ++i) {
            b[i] = ZERO;
        }
        return ComplexFFT_1D.cconvolve(a, b);
    }

    public static Complex[] fft(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        int base = (int)(Math.log(N / 2) / Math.log(2.0)) + 1;
        boolean precalculate = true;
        if (base > 17) {
            precalculate = false;
        }
        if ((coef == null || base > coef_order) && precalculate) {
            int order = 0;
            order = base < 16 ? 16 : base + 1;
            coef = new Complex[order][];
            for (int i = 0; i < order; ++i) {
                ComplexFFT_1D.coef[i] = new Complex[(int)Math.pow(2.0, i)];
                for (int j = 0; j < (int)Math.pow(2.0, i); ++j) {
                    double kth = (double)(-2 * j) * Math.PI / Math.pow(2.0, i);
                    ComplexFFT_1D.coef[i][j] = new Complex(Math.cos(kth), Math.sin(kth));
                }
            }
            coef_order = order;
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = ComplexFFT_1D.fft(even);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = ComplexFFT_1D.fft(odd);
        Complex[] y = new Complex[N];
        for (int k = 0; k < N / 2; ++k) {
            if (precalculate) {
                y[k] = q[k].add(coef[base][k].multiply(r[k]));
                y[k + N / 2] = q[k].subtract(coef[base][k].multiply(r[k]));
                continue;
            }
            double kth = (double)(-2 * k) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k] = q[k].add(wk.multiply(r[k]));
            y[k + N / 2] = q[k].subtract(wk.multiply(r[k]));
        }
        return y;
    }

    public static Complex[] fft_orig(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = ComplexFFT_1D.fft(even);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = ComplexFFT_1D.fft(odd);
        Complex[] y = new Complex[N];
        for (int k = 0; k < N / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k] = q[k].add(wk.multiply(r[k]));
            y[k + N / 2] = q[k].subtract(wk.multiply(r[k]));
        }
        return y;
    }

    public static Complex[] ifft(Complex[] x) {
        int i;
        int N = x.length;
        Complex[] y = new Complex[N];
        for (i = 0; i < N; ++i) {
            y[i] = x[i].conjugate();
        }
        y = ComplexFFT_1D.fft(y);
        for (i = 0; i < N; ++i) {
            y[i] = y[i].conjugate();
        }
        for (i = 0; i < N; ++i) {
            y[i] = y[i].multiply(1.0 / (double)N);
        }
        return y;
    }

    public static void main(String[] args) {
        int i;
        int N = 1024;
        Complex[] x = new Complex[1024];
        for (i = 0; i < 1024; ++i) {
            x[i] = new Complex((double)i, 0.0);
            x[i] = new Complex(-2.0 * Math.random() + 1.0, 0.0);
        }
        System.out.println("x");
        System.out.println("-------------------");
        for (i = 0; i < 1024; ++i) {
            System.out.println(x[i]);
        }
        System.out.println();
        Complex[] y = ComplexFFT_1D.fft(x);
        System.out.println("y = fft(x)");
        System.out.println("-------------------");
        for (int i2 = 0; i2 < 1024; ++i2) {
            System.out.println(y[i2]);
        }
        System.out.println();
        Complex[] z = ComplexFFT_1D.ifft(y);
        System.out.println("z = ifft(y)");
        System.out.println("-------------------");
        for (int i3 = 0; i3 < 1024; ++i3) {
            System.out.println(z[i3]);
        }
        System.out.println();
        Complex[] c = ComplexFFT_1D.cconvolve(x, x);
        System.out.println("c = cconvolve(x, x)");
        System.out.println("-------------------");
        for (int i4 = 0; i4 < 1024; ++i4) {
            System.out.println(c[i4]);
        }
        System.out.println();
        Complex[] d = ComplexFFT_1D.convolve(x, x);
        System.out.println("d = convolve(x, x)");
        System.out.println("-------------------");
        for (int i5 = 0; i5 < d.length; ++i5) {
            System.out.println(d[i5]);
        }
        System.out.println();
    }

    static {
        coef_order = 0;
    }
}

