/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.lomb;

import de.gsi.math.TMath;
import de.gsi.math.TMathConstants;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LombPeriodogram {
    private static final Logger LOGGER = LoggerFactory.getLogger(LombPeriodogram.class);
    protected static final int START_THREADS = 256;

    private LombPeriodogram() {
    }

    public static double[] computeFrequencyRange(double[] time) {
        double t_range = TMath.Maximum(time) - TMath.Minimum(time);
        double tMin = Double.MAX_VALUE;
        for (int i = 1; i < time.length; ++i) {
            double diff = TMathConstants.Abs(time[i] - time[i - 1]);
            if (!(tMin > diff) || !(tMin > 0.0)) continue;
            tMin = diff;
        }
        double f_s = 1.0 / tMin;
        int nTestFrequencies = (int)(t_range / tMin);
        double[] testFrequencies = new double[nTestFrequencies];
        double scale = 0.5 / (double)nTestFrequencies * f_s;
        for (int i = 0; i < nTestFrequencies; ++i) {
            testFrequencies[i] = (double)i * scale;
        }
        return testFrequencies;
    }

    public static double[] computePeridodogram(double[] t, double[] val) {
        return LombPeriodogram.computePeridodogram(t, val, LombPeriodogram.computeFrequencyRange(t));
    }

    public static double[] computePeridodogram(double[] t, double[] val, double[] testFrequencies) {
        int n = testFrequencies.length;
        double[] ret = new double[n];
        long start = System.nanoTime();
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < t.length; ++i) {
            sum1 += TMathConstants.Sin(TMathConstants.TwoPi() * t[i]);
            sum2 += TMathConstants.Cos(TMathConstants.TwoPi() * t[i]);
        }
        double tau = TMathConstants.ATan2(sum1, sum2) / TMathConstants.TwoPi();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && n > 256) {
            Future[] futures = new Future[nthreads];
            int k = n / nthreads;
            for (int thread = 0; thread < nthreads; ++thread) {
                int firstIdx = thread * k;
                int lastIdx = thread == nthreads - 1 ? n : firstIdx + k;
                futures[thread] = ConcurrencyUtils.submit(() -> {
                    for (int i = firstIdx; i < lastIdx; ++i) {
                        double omega = TMathConstants.TwoPi() * testFrequencies[i];
                        double sum11 = 0.0;
                        double sum12 = 0.0;
                        double sum21 = 0.0;
                        double sum22 = 0.0;
                        for (int j = 0; j < t.length; ++j) {
                            sum11 += val[j] * TMathConstants.Cos(omega * (t[j] - tau));
                            sum21 += val[j] * TMathConstants.Sin(omega * (t[j] - tau));
                            sum12 += TMathConstants.Sqr(TMathConstants.Cos(omega * (t[j] - tau)));
                            sum22 += TMathConstants.Sqr(TMathConstants.Sin(omega * (t[j] - tau)));
                        }
                        ret[i] = sum12 <= 0.0 || sum22 <= 0.0 ? 0.0 : TMathConstants.Sqrt(2.0 * (TMathConstants.Sqr(sum11) / sum12 + TMathConstants.Sqr(sum21) / sum22) / (double)t.length);
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < n; ++i) {
                double omega = TMathConstants.TwoPi() * testFrequencies[i];
                double sum11 = 0.0;
                double sum12 = 0.0;
                double sum21 = 0.0;
                double sum22 = 0.0;
                for (int j = 0; j < t.length; ++j) {
                    sum11 += val[j] * TMathConstants.Cos(omega * (t[j] - tau));
                    sum21 += val[j] * TMathConstants.Sin(omega * (t[j] - tau));
                    sum12 += TMathConstants.Sqr(TMathConstants.Cos(omega * (t[j] - tau)));
                    sum22 += TMathConstants.Sqr(TMathConstants.Sin(omega * (t[j] - tau)));
                }
                ret[i] = sum12 <= 0.0 || sum22 <= 0.0 ? 0.0 : TMathConstants.Sqrt(2.0 * (TMathConstants.Sqr(sum11) / sum12 + TMathConstants.Sqr(sum21) / sum22) / (double)t.length);
            }
        }
        long stop = System.nanoTime();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)((double)(stop - start) * 1.0E-6)).log("LombPeriodogram(double[], double[], double[]) - took {} ms");
        }
        return ret;
    }
}

