/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.storage;

import de.gsi.math.storage.VoxelArrayND;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class DoubleStorageND
implements VoxelArrayND {
    private int fndimIn;
    private int fdimOut;
    private int[] flength;
    private double[][] fdata;

    public DoubleStorageND(DoubleStorageND data) {
        int i;
        this.fndimIn = data.fndimIn;
        this.fdimOut = data.fdimOut;
        this.flength = Arrays.copyOf(data.flength, data.flength.length);
        int rlength = 1;
        for (i = 0; i < this.fndimIn; ++i) {
            rlength *= this.flength[i];
        }
        this.fdata = new double[rlength][this.fdimOut];
        for (i = 0; i < rlength; ++i) {
            this.fdata[i] = Arrays.copyOf(data.fdata[i], data.fdata[i].length);
        }
    }

    public DoubleStorageND(int[] dimIn, int outDim) {
        this.fndimIn = dimIn.length;
        this.fdimOut = outDim;
        this.flength = Arrays.copyOf(dimIn, dimIn.length);
        int rlength = 1;
        for (int i = 0; i < this.fndimIn; ++i) {
            rlength *= this.flength[i];
        }
        this.fdata = new double[rlength][this.fdimOut];
    }

    @Override
    public VoxelArrayND copy() {
        return new DoubleStorageND(this);
    }

    @Override
    public double[] get(int[] index) {
        int rindex = this.getLocalIndex(index);
        return this.fdata[rindex];
    }

    @Override
    public int[] getInverseLocalIndex(int index) {
        int lindex = index;
        int[] ret = new int[this.fndimIn];
        for (int i = 0; i < this.fndimIn; ++i) {
            int multiplicator = 1;
            for (int j = i; j < this.fndimIn - 1; ++j) {
                multiplicator *= this.flength[j + 1];
            }
            ret[i] = lindex / multiplicator;
            lindex -= ret[i] * multiplicator;
        }
        return ret;
    }

    @Override
    public double[] getLocal(int localIndex) {
        return this.fdata[localIndex];
    }

    @Override
    public int getLocalIndex(int[] index) {
        int ret = 0;
        for (int i = 0; i < this.fndimIn; ++i) {
            int multiplicator = 1;
            for (int j = i; j < this.fndimIn - 1; ++j) {
                multiplicator *= this.flength[j + 1];
            }
            ret += multiplicator * index[i];
        }
        return ret;
    }

    @Override
    public int getLocalStorageDim() {
        return this.fdata.length;
    }

    @Override
    public int getValueDimension() {
        return this.fdimOut;
    }

    @Override
    public void initialiseWithValue(double val) {
        for (int i = 0; i < this.fdata.length; ++i) {
            for (int j = 0; j < this.fdata[i].length; ++j) {
                this.fdata[i][j] = val;
            }
        }
    }

    @Override
    public void set(int[] index, double[] val) {
        if (val.length != this.fdimOut) {
            throw new InvalidParameterException("invalid value dimension " + val.length);
        }
        int rindex = this.getLocalIndex(index);
        this.fdata[rindex] = val;
    }

    @Override
    public void setLocal(int localIndex, double[] val) {
        this.fdata[localIndex] = val;
    }

    public static void main(String[] argv) {
        int i;
        DoubleStorageND test1 = new DoubleStorageND(new int[]{3, 5}, 10);
        for (int i2 = 0; i2 < 3; ++i2) {
            int j = 0;
            while (j < 5) {
                System.out.printf("1:tupple index (%d,%d) mapped to %d\n", i2, j, test1.getLocalIndex(new int[]{i2, j++}));
            }
        }
        DoubleStorageND test2 = new DoubleStorageND(new int[]{3, 5, 2}, 10);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 5; ++j) {
                int k = 0;
                while (k < 2) {
                    System.out.printf("2:tupple index (%d,%d,%d) mapped to %d\n", i, j, k, test2.getLocalIndex(new int[]{i, j, k++}));
                }
            }
        }
        System.out.println();
        for (i = 0; i < test2.getLocalStorageDim(); ++i) {
            int[] lindex = test2.getInverseLocalIndex(i);
            System.out.printf("2:inverse tupple index %3d mapped to (%d,%d,%d)\n", i, lindex[0], lindex[1], lindex[2]);
        }
    }
}

