/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate4;

import com.pyx4j.log4j.MavenLogAppender;
import de.juplo.plugins.hibernate4.ValidationConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.ProviderChecker;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.Target;
import org.scannotation.AnnotationDB;

public class Hbm2DdlMojo
extends AbstractMojo {
    public static final String EXPORT_SKIPPED_PROPERTY = "hibernate.export.skipped";
    public static final String DRIVER_CLASS = "hibernate.connection.driver_class";
    public static final String URL = "hibernate.connection.url";
    public static final String USERNAME = "hibernate.connection.username";
    public static final String PASSWORD = "hibernate.connection.password";
    public static final String DIALECT = "hibernate.dialect";
    public static final String NAMING_STRATEGY = "hibernate.ejb.naming_strategy";
    public static final String ENVERS = "hibernate.export.envers";
    public static final String JPA_DRIVER = "javax.persistence.jdbc.driver";
    public static final String JPA_URL = "javax.persistence.jdbc.url";
    public static final String JPA_USERNAME = "javax.persistence.jdbc.user";
    public static final String JPA_PASSWORD = "javax.persistence.jdbc.password";
    public static final String MD5S = "hibernate4-generatedschema.md5s";
    private static final Pattern split = Pattern.compile("[^,\\s]+");
    private MavenProject project;
    private String buildDirectory;
    private String outputDirectory;
    private boolean scanTestClasses;
    private String scanDependencies;
    private String testOutputDirectory;
    private boolean skip;
    private boolean force;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String hibernateDialect;
    private String hibernateNamingStrategy;
    private String hibernateProperties;
    private String hibernateConfig;
    private String persistenceUnit;
    private String hibernateMapping;
    private String target;
    private String type;
    private String outputFile;
    private String delimiter;
    private boolean format;
    private boolean envers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        HashMap md5s;
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution of hibernate4-maven-plugin:export was skipped!");
            this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
            return;
        }
        boolean modified = false;
        File saved = new File(this.buildDirectory + File.separator + MD5S);
        if (saved.isFile() && saved.length() > 0L) {
            try {
                FileInputStream fis = new FileInputStream(saved);
                ObjectInputStream ois = new ObjectInputStream(fis);
                md5s = (HashMap)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                md5s = new HashMap();
                this.getLog().warn((CharSequence)("Cannot read timestamps from saved: " + e));
            }
        } else {
            md5s = new HashMap();
            try {
                saved.createNewFile();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Cannot create file \"" + saved.getPath() + "\" for timestamps: " + e));
            }
        }
        URLClassLoader classLoader = null;
        try {
            this.getLog().debug((CharSequence)"Creating ClassLoader for project-dependencies...");
            List classpathFiles = this.project.getCompileClasspathElements();
            if (this.scanTestClasses) {
                classpathFiles.addAll(this.project.getTestClasspathElements());
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            File file = new File(this.testOutputDirectory);
            if (!file.exists()) {
                this.getLog().info((CharSequence)("creating test-output-directory: " + this.testOutputDirectory));
                file.mkdirs();
            }
            urls.add(file.toURI().toURL());
            file = new File(this.outputDirectory);
            if (!file.exists()) {
                this.getLog().info((CharSequence)("creating output-directory: " + this.outputDirectory));
                file.mkdirs();
            }
            urls.add(file.toURI().toURL());
            for (Object pathElement : classpathFiles) {
                this.getLog().debug((CharSequence)("Dependency: " + (String)pathElement));
                urls.add(new File((String)pathElement).toURI().toURL());
            }
            classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while creating ClassLoader!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        TreeSet classes = new TreeSet(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> a, Class<?> b) {
                return a.getName().compareTo(b.getName());
            }
        });
        try {
            URL dirUrl;
            AnnotationDB db = new AnnotationDB();
            File dir = new File(this.outputDirectory);
            if (dir.exists()) {
                this.getLog().info((CharSequence)("Scanning directory " + this.outputDirectory + " for annotated classes..."));
                dirUrl = dir.toURI().toURL();
                db.scanArchives(new URL[]{dirUrl});
            }
            if (this.scanTestClasses && (dir = new File(this.testOutputDirectory)).exists()) {
                this.getLog().info((CharSequence)("Scanning directory " + this.testOutputDirectory + " for annotated classes..."));
                dirUrl = dir.toURI().toURL();
                db.scanArchives(new URL[]{dirUrl});
            }
            if (this.scanDependencies != null) {
                Matcher matcher = split.matcher(this.scanDependencies);
                while (matcher.find()) {
                    this.getLog().info((CharSequence)("Scanning dependencies for scope " + matcher.group()));
                    for (Artifact artifact : this.project.getDependencyArtifacts()) {
                        if (!artifact.getScope().equalsIgnoreCase(matcher.group())) continue;
                        if (artifact.getFile() == null) {
                            this.getLog().warn((CharSequence)("Cannot scan dependency " + artifact.getId() + ": no JAR-file available!"));
                            continue;
                        }
                        this.getLog().info((CharSequence)("Scanning dependency " + artifact.getId() + " for annotated classes..."));
                        db.scanArchives(new URL[]{artifact.getFile().toURI().toURL()});
                    }
                }
            }
            HashSet classNames = new HashSet();
            if (db.getAnnotationIndex().containsKey(Entity.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(Entity.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(MappedSuperclass.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(MappedSuperclass.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(Embeddable.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(Embeddable.class.getName()));
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (String string : classNames) {
                String oldMd5;
                int i;
                Class<?> clazz = classLoader.loadClass(string);
                classes.add(clazz);
                String resourceName = clazz.getName();
                resourceName = resourceName.substring(resourceName.lastIndexOf(".") + 1, resourceName.length()) + ".class";
                InputStream is = clazz.getResourceAsStream(resourceName);
                byte[] buffer = new byte[4096];
                while ((i = is.read(buffer)) > -1) {
                    digest.update(buffer, 0, i);
                }
                is.close();
                byte[] bytes = digest.digest();
                BigInteger bi = new BigInteger(1, bytes);
                String newMd5 = String.format("%0" + (bytes.length << 1) + "x", bi);
                String string2 = oldMd5 = !md5s.containsKey(string) ? "" : (String)md5s.get(string);
                if (!newMd5.equals(oldMd5)) {
                    this.getLog().debug((CharSequence)("Found new or modified annotated class: " + string));
                    modified = true;
                    md5s.put(string, newMd5);
                    continue;
                }
                this.getLog().debug((CharSequence)(oldMd5 + " -> class unchanged: " + string));
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)"Error while adding annotated classes!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while scanning!", (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
        ValidationConfiguration config = new ValidationConfiguration();
        config.setProperties(new Properties());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        StandardServiceRegistryImpl registry = null;
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            File outFileParentDir;
            SchemaExport.Type type;
            Target target;
            Object dialect;
            String password;
            String username;
            String url;
            String driver;
            File file;
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Properties properties;
                if (this.hibernateProperties == null) {
                    URL url2 = classLoader.findResource("hibernate.properties");
                    if (url2 == null) {
                        this.getLog().info((CharSequence)"No hibernate.properties on the classpath!");
                    } else {
                        this.getLog().info((CharSequence)"Reading settings from hibernate.properties on the classpath.");
                        properties = new Properties();
                        properties.load(url2.openStream());
                        config.setProperties(properties);
                    }
                } else {
                    file = new File(this.hibernateProperties);
                    if (file.exists()) {
                        this.getLog().info((CharSequence)("Reading settings from file " + this.hibernateProperties + "..."));
                        properties = new Properties();
                        properties.load(new FileInputStream(file));
                        config.setProperties(properties);
                    } else {
                        this.getLog().info((CharSequence)("No hibernate-properties-file found! (Checked path: " + this.hibernateProperties + ")"));
                    }
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error while reading properties!", (Throwable)e);
                throw new MojoExecutionException(e.getMessage());
            }
            try {
                if (this.hibernateConfig == null) {
                    URL url2 = classLoader.findResource("hibernate.cfg.xml");
                    if (url2 == null) {
                        this.getLog().info((CharSequence)"No hibernate.cfg.xml on the classpath!");
                    } else {
                        this.getLog().info((CharSequence)"Reading settings from hibernate.cfg.xml on the classpath.");
                        config.configure(url2);
                    }
                } else {
                    file = new File(this.hibernateConfig);
                    if (file.exists()) {
                        this.getLog().info((CharSequence)("Reading configuration from file " + this.hibernateConfig + "..."));
                        config.configure(file);
                    } else {
                        this.getLog().info((CharSequence)("No hibernate-configuration-file found! (Checked path: " + this.hibernateConfig + ")"));
                    }
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error while reading configuration!", (Throwable)e);
                throw new MojoExecutionException(e.getMessage());
            }
            ParsedPersistenceXmlDescriptor persistenceUnitDescriptor = this.getPersistenceUnitDescriptor(this.persistenceUnit, config.getProperties(), new MavenProjectClassLoaderService(classLoader));
            if (persistenceUnitDescriptor != null) {
                config.setProperties(persistenceUnitDescriptor.getProperties());
            }
            if (this.driverClassName != null) {
                if (config.getProperties().containsKey(DRIVER_CLASS)) {
                    this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.driver_class=" + config.getProperty(DRIVER_CLASS) + " with the value " + this.driverClassName));
                } else {
                    this.getLog().debug((CharSequence)("Using the value " + this.driverClassName));
                }
                config.setProperty(DRIVER_CLASS, this.driverClassName);
            }
            if (config.getProperty(DRIVER_CLASS) == null && (driver = config.getProperty(JPA_DRIVER)) != null) {
                this.getLog().info((CharSequence)("hibernate.connection.driver_class is not set. Borrow setting from javax.persistence.jdbc.driver: " + driver));
                config.setProperty(DRIVER_CLASS, driver);
            }
            if (this.url != null) {
                if (config.getProperties().containsKey(URL)) {
                    this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.url=" + config.getProperty(URL) + " with the value " + this.url));
                } else {
                    this.getLog().debug((CharSequence)("Using the value " + this.url));
                }
                config.setProperty(URL, this.url);
            }
            if (config.getProperty(URL) == null && (url = config.getProperty(JPA_URL)) != null) {
                this.getLog().info((CharSequence)("hibernate.connection.url is not set. Borrow setting from javax.persistence.jdbc.url: " + url));
                config.setProperty(URL, url);
            }
            if (this.username != null) {
                if (config.getProperties().containsKey(USERNAME)) {
                    this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.username=" + config.getProperty(USERNAME) + " with the value " + this.username));
                } else {
                    this.getLog().debug((CharSequence)("Using the value " + this.username));
                }
                config.setProperty(USERNAME, this.username);
            }
            if (config.getProperty(USERNAME) == null && (username = config.getProperty(JPA_USERNAME)) != null) {
                this.getLog().info((CharSequence)("hibernate.connection.username is not set. Borrow setting from javax.persistence.jdbc.user: " + username));
                config.setProperty(USERNAME, username);
            }
            if (this.password != null) {
                if (config.getProperties().containsKey(PASSWORD)) {
                    this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.password=" + config.getProperty(PASSWORD) + " with value " + this.password));
                } else {
                    this.getLog().debug((CharSequence)("Using value " + this.password + " for property " + PASSWORD));
                }
                config.setProperty(PASSWORD, this.password);
            }
            if (config.getProperty(PASSWORD) == null && (password = config.getProperty(JPA_PASSWORD)) != null) {
                this.getLog().info((CharSequence)("hibernate.connection.password is not set. Borrow setting from javax.persistence.jdbc.password: " + password));
                config.setProperty(PASSWORD, password);
            }
            if (this.hibernateDialect != null) {
                if (config.getProperties().containsKey(DIALECT)) {
                    this.getLog().debug((CharSequence)("Overwriting property hibernate.dialect=" + config.getProperty(DIALECT) + " with value " + this.hibernateDialect));
                } else {
                    this.getLog().debug((CharSequence)("Using value " + this.hibernateDialect + " for property " + DIALECT));
                }
                config.setProperty(DIALECT, this.hibernateDialect);
            }
            if (this.hibernateNamingStrategy != null) {
                if (config.getProperties().contains(NAMING_STRATEGY)) {
                    this.getLog().debug((CharSequence)("Overwriting property hibernate.ejb.naming_strategy=" + config.getProperty(NAMING_STRATEGY) + " with value " + this.hibernateNamingStrategy));
                } else {
                    this.getLog().debug((CharSequence)("Using value " + this.hibernateNamingStrategy + " for property " + NAMING_STRATEGY));
                }
                config.setProperty(NAMING_STRATEGY, this.hibernateNamingStrategy);
            }
            if (md5s.containsKey(DIALECT)) {
                dialect = config.getProperty(DIALECT);
                if (((String)md5s.get(DIALECT)).equals(dialect)) {
                    this.getLog().debug((CharSequence)"SQL-dialect unchanged.");
                } else {
                    modified = true;
                    if (dialect == null) {
                        this.getLog().debug((CharSequence)"SQL-dialect was unset.");
                        md5s.remove(DIALECT);
                    } else {
                        this.getLog().debug((CharSequence)("SQL-dialect changed: " + (String)dialect));
                        md5s.put(DIALECT, dialect);
                    }
                }
            } else {
                dialect = config.getProperty(DIALECT);
                if (dialect != null) {
                    modified = true;
                    md5s.put(DIALECT, config.getProperty(DIALECT));
                }
            }
            if (md5s.get(ENVERS) != null) {
                if (((String)md5s.get(ENVERS)).equals(Boolean.toString(this.envers))) {
                    this.getLog().debug((CharSequence)("Envers-Configuration unchanged. Enabled: " + this.envers));
                } else {
                    this.getLog().debug((CharSequence)("Envers-Configuration changed. Enabled: " + this.envers));
                    modified = true;
                    md5s.put(ENVERS, Boolean.toString(this.envers));
                }
            } else {
                modified = true;
                md5s.put(ENVERS, Boolean.toString(this.envers));
            }
            if (config.getProperties().isEmpty()) {
                this.getLog().error((CharSequence)"No properties set!");
                throw new MojoFailureException("Hibernate configuration is missing!");
            }
            this.getLog().info((CharSequence)"Gathered hibernate-configuration (turn on debugging for details):");
            for (Map.Entry entry : config.getProperties().entrySet()) {
                this.getLog().info((CharSequence)("  " + entry.getKey() + " = " + entry.getValue()));
            }
            this.getLog().debug((CharSequence)"Adding explicitly configured mappings...");
            if (this.hibernateMapping != null) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    for (String filename : this.hibernateMapping.split("[\\s,]+")) {
                        File file2 = new File(filename);
                        if (!file2.exists()) {
                            Resource resource;
                            Iterator i = this.project.getResources().iterator();
                            while (i.hasNext() && !(file2 = new File((resource = (Resource)i.next()).getDirectory() + File.separator + filename)).exists()) {
                            }
                        }
                        if (file2 != null && file2.exists()) {
                            String oldMd5;
                            int i;
                            FileInputStream is = new FileInputStream(file2);
                            byte[] buffer = new byte[4096];
                            while ((i = ((InputStream)is).read(buffer)) > -1) {
                                digest.update(buffer, 0, i);
                            }
                            ((InputStream)is).close();
                            byte[] bytes = digest.digest();
                            BigInteger bi = new BigInteger(1, bytes);
                            String newMd5 = String.format("%0" + (bytes.length << 1) + "x", bi);
                            String string = oldMd5 = !md5s.containsKey(filename) ? "" : (String)md5s.get(filename);
                            if (!newMd5.equals(oldMd5)) {
                                this.getLog().debug((CharSequence)("Found new or modified mapping-file: " + filename));
                                modified = true;
                                md5s.put(filename, newMd5);
                            } else {
                                this.getLog().debug((CharSequence)(oldMd5 + " -> mapping-file unchanged: " + filename));
                            }
                        } else {
                            throw new MojoFailureException("File " + filename + " could not be found in any of the configured resource-directories!");
                        }
                        this.getLog().debug((CharSequence)("Adding mappings from XML-configurationfile: " + file2));
                        config.addFile(file2);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new MojoFailureException("Cannot calculate MD5 sums!", (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new MojoFailureException("Cannot calculate MD5 sums!", (Throwable)e);
                }
                catch (IOException e) {
                    throw new MojoFailureException("Cannot calculate MD5 sums!", (Throwable)e);
                }
            }
            this.getLog().debug((CharSequence)"Adding annotated classes to hibernate-mapping-configuration...");
            HashSet<String> packages = new HashSet<String>();
            for (Class clazz : classes) {
                String packageName = clazz.getPackage().getName();
                if (!packages.contains(packageName)) {
                    this.getLog().debug((CharSequence)("Add package " + packageName));
                    packages.add(packageName);
                    config.addPackage(packageName);
                    this.getLog().debug((CharSequence)("type definintions" + config.getTypeDefs()));
                }
                this.getLog().debug((CharSequence)("Class " + clazz));
                config.addAnnotatedClass(clazz);
            }
            Object var11_28 = null;
            try {
                target = Target.valueOf((String)this.target.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getLog().error((CharSequence)("Invalid value for configuration-option \"target\": " + this.target));
                this.getLog().error((CharSequence)"Valid values are: NONE, SCRIPT, EXPORT, BOTH");
                throw new MojoExecutionException("Invalid value for configuration-option \"target\"");
            }
            Object var12_34 = null;
            try {
                type = SchemaExport.Type.valueOf((String)this.type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLog().error((CharSequence)("Invalid value for configuration-option \"type\": " + this.type));
                this.getLog().error((CharSequence)"Valid values are: NONE, CREATE, DROP, BOTH");
                throw new MojoExecutionException("Invalid value for configuration-option \"type\"");
            }
            if (config.getProperty(DIALECT) == null) {
                throw new MojoFailureException("hibernate-dialect must be set!");
            }
            if (target.equals((Object)Target.SCRIPT) || target.equals((Object)Target.NONE)) {
                this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
            }
            if (!(modified || target.equals((Object)Target.SCRIPT) || target.equals((Object)Target.NONE) || this.force)) {
                this.getLog().info((CharSequence)"No modified annotated classes or mapping-files found and dialect unchanged.");
                this.getLog().info((CharSequence)"Skipping schema generation!");
                this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
                return;
            }
            if (config.getProperties().containsKey(NAMING_STRATEGY)) {
                String namingStrategy = config.getProperty(NAMING_STRATEGY);
                this.getLog().debug((CharSequence)("Explicitly set NamingStrategy: " + namingStrategy));
                try {
                    List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
                    URL[] runtimeUrls = new URL[runtimeClasspathElements.size()];
                    for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
                        String element = (String)runtimeClasspathElements.get(i);
                        runtimeUrls[i] = new File(element).toURI().toURL();
                    }
                    URLClassLoader newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
                    Class<?> namingStrategyClass = newLoader.loadClass(namingStrategy);
                    config.setNamingStrategy((NamingStrategy)namingStrategyClass.newInstance());
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Error setting NamingStrategy", (Throwable)e);
                    throw new MojoExecutionException(e.getMessage());
                }
            }
            Environment.verifyProperties((Map)config.getProperties());
            ConfigurationHelper.resolvePlaceHolders((Map)config.getProperties());
            registry = (StandardServiceRegistryImpl)new StandardServiceRegistryBuilder().applySettings((Map)config.getProperties()).build();
            config.buildMappings();
            if (this.envers) {
                this.getLog().info((CharSequence)"Automatic auditing via hibernate-envers enabled!");
                AuditConfiguration.getFor((Configuration)config);
            }
            SchemaExport export = new SchemaExport((ServiceRegistry)registry, (Configuration)config);
            export.setDelimiter(this.delimiter);
            export.setFormat(this.format);
            File outF = new File(this.outputFile);
            if (!outF.isAbsolute()) {
                outF = new File(this.buildDirectory, this.outputFile);
                this.getLog().info((CharSequence)("Adjusted relative path, resulting path is " + outF.getPath()));
            }
            if (null != (outFileParentDir = outF.getParentFile()) && !outFileParentDir.exists()) {
                try {
                    this.getLog().info((CharSequence)("Creating directory path for output file:" + outFileParentDir.getPath()));
                    outFileParentDir.mkdirs();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Error creating directory path for output file: " + e.getLocalizedMessage()));
                }
            }
            export.setOutputFile(outF.getPath());
            export.execute(target, type);
            for (Object exception : export.getExceptions()) {
                this.getLog().debug((CharSequence)exception.toString());
            }
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            if (registry != null) {
                registry.destroy();
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(saved);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(md5s);
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Cannot write md5-sums to file: " + e));
        }
    }

    private ParsedPersistenceXmlDescriptor getPersistenceUnitDescriptor(String name, Properties properties, ClassLoaderService loader) throws MojoFailureException {
        PersistenceXmlParser parser = new PersistenceXmlParser(loader, PersistenceUnitTransactionType.RESOURCE_LOCAL);
        List units = parser.doResolve((Map)properties);
        if (name == null) {
            switch (units.size()) {
                case 0: {
                    this.getLog().info((CharSequence)"Found no META-INF/persistence.xml.");
                    return null;
                }
                case 1: {
                    this.getLog().info((CharSequence)("Using persistence-unit " + ((ParsedPersistenceXmlDescriptor)units.get(0)).getName()));
                    return (ParsedPersistenceXmlDescriptor)units.get(0);
                }
            }
            this.getLog().warn((CharSequence)"No name provided and multiple persistence units found:");
            for (ParsedPersistenceXmlDescriptor unit : units) {
                this.getLog().warn((CharSequence)(" - " + unit.getName()));
            }
            return null;
        }
        for (ParsedPersistenceXmlDescriptor unit : units) {
            this.getLog().debug((CharSequence)("Found persistence-unit " + unit.getName()));
            if (!unit.getName().equals(name)) continue;
            if (!ProviderChecker.isProvider((PersistenceUnitDescriptor)unit, (Map)properties)) {
                this.getLog().debug((CharSequence)("Wrong provider: " + unit.getProviderClassName()));
                continue;
            }
            this.getLog().info((CharSequence)("Using persistence-unit " + unit.getName()));
            return unit;
        }
        throw new MojoFailureException("Could not find persistence-unit " + name);
    }

    static final class DriverProxy
    implements Driver {
        private final Driver target;

        DriverProxy(Driver target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
        }

        public Driver getTarget() {
            return this.target;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.target.acceptsURL(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.target.connect(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.target.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.target.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.target.getPropertyInfo(url, info);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.target.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported, for backward-compatibility with Java 1.6");
        }

        public String toString() {
            return "Proxy: " + this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DriverProxy)) {
                return false;
            }
            DriverProxy other = (DriverProxy)obj;
            return this.target.equals(other.target);
        }
    }

    static final class MavenProjectClassLoaderService
    implements ClassLoaderService {
        private final ClassLoader loader;

        public MavenProjectClassLoaderService(ClassLoader loader) {
            this.loader = loader;
        }

        public <T> Class<T> classForName(String name) {
            try {
                return this.loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassLoadingException("Unable to load class [" + name + "]", (Throwable)e);
            }
        }

        public URL locateResource(String name) {
            return this.loader.getResource(name);
        }

        public InputStream locateResourceStream(String name) {
            return this.loader.getResourceAsStream(name);
        }

        public List<URL> locateResources(String name) {
            try {
                return Collections.list(this.loader.getResources(name));
            }
            catch (IOException e) {
                return Collections.EMPTY_LIST;
            }
        }

        public <S> LinkedHashSet<S> loadJavaServices(Class<S> serviceContract) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void stop() {
        }
    }
}

