/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.api;

import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.impl.input.ByteArrayInput;
import de.kosit.validationtool.impl.input.ResourceInput;
import de.kosit.validationtool.impl.input.SourceInput;
import de.kosit.validationtool.impl.input.StreamHelper;
import de.kosit.validationtool.impl.input.XdmNodeInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.UUID;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFactory {
    private static final Logger log = LoggerFactory.getLogger(InputFactory.class);
    static final String DEFAULT_ALGORITH = "SHA-256";
    static final String PSEUDO_NAME_ALGORITHM = "NAME";
    private static final String MESSAGE_OPEN_STREAM_ERROR = "Can not open stream from";
    private final String algorithm;

    InputFactory() {
        this(null);
    }

    InputFactory(String specifiedAlgorithm) {
        this.algorithm = StringUtils.isNotEmpty((CharSequence)specifiedAlgorithm) ? specifiedAlgorithm : DEFAULT_ALGORITH;
        StreamHelper.createDigest(this.algorithm);
    }

    public static Input read(Path path) {
        return InputFactory.read(path, DEFAULT_ALGORITH);
    }

    public static Input read(Path path, String digestAlgorithm) {
        InputFactory.checkNull(path);
        return InputFactory.read(path.toUri(), digestAlgorithm);
    }

    public static Input read(File file) {
        return InputFactory.read(file, DEFAULT_ALGORITH);
    }

    public static Input read(URI uri) {
        return InputFactory.read(uri, DEFAULT_ALGORITH);
    }

    public static Input read(URI uri, String digestAlgorithm) {
        try {
            return InputFactory.read(uri.toURL(), digestAlgorithm);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("URL invalid or protocol not supported: %s", uri), e);
        }
    }

    public static Input read(URL url) {
        return InputFactory.read(url, DEFAULT_ALGORITH);
    }

    public static Input read(URL url, String digestAlgorithm) {
        InputFactory.checkNull(url);
        InputFactory.checkNotEmpty(url.getFile());
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(MESSAGE_OPEN_STREAM_ERROR + url, e);
        }
        return new ResourceInput(url, url.getFile(), digestAlgorithm);
    }

    public static Input read(Source source) {
        if (source instanceof StreamSource) {
            return InputFactory.read(source, source.getSystemId(), DEFAULT_ALGORITH);
        }
        String name = UUID.randomUUID().toString();
        return InputFactory.read(source, name, PSEUDO_NAME_ALGORITHM, name.getBytes());
    }

    public static Input read(Source source, String name) {
        InputFactory.checkNotEmpty(name);
        return InputFactory.read(source, name, PSEUDO_NAME_ALGORITHM, name.getBytes());
    }

    public static Input read(Source source, String name, String digestAlgorithm) {
        return InputFactory.read(source, name, digestAlgorithm, null);
    }

    public static Input read(Source source, String digestAlgorithm, byte[] hashcode) {
        InputFactory.checkNull(source);
        return InputFactory.read(source, source.getSystemId(), digestAlgorithm, hashcode);
    }

    public static Input read(Source source, String name, String digestAlgorithm, byte[] hashcode) {
        InputFactory.checkNull(source);
        return new SourceInput(source, name, digestAlgorithm, hashcode);
    }

    public static Input read(File file, String digestAlgorithm) {
        InputFactory.checkNull(file);
        try {
            return InputFactory.read(file.toURI().toURL(), digestAlgorithm);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(MESSAGE_OPEN_STREAM_ERROR + file, e);
        }
    }

    public static Input read(byte[] input, String name) {
        InputFactory.checkNull(input);
        return InputFactory.read(input, name, DEFAULT_ALGORITH);
    }

    public static Input read(byte[] input, String name, String digestAlgorithm) {
        InputFactory.checkNull(input);
        InputFactory.checkNotEmpty(name);
        return new ByteArrayInput(input, name, digestAlgorithm);
    }

    private static void checkNotEmpty(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Input name can not be null");
        }
    }

    private static void checkNull(Object input) {
        if (input == null) {
            throw new IllegalArgumentException("Input can not be null");
        }
    }

    public static Input read(InputStream inputStream, String name) {
        return InputFactory.read(inputStream, name, DEFAULT_ALGORITH);
    }

    public static Input read(InputStream inputStream, String name, String digestAlgorithm) {
        InputFactory.checkNull(inputStream);
        return InputFactory.read((Source)new StreamSource(inputStream, name), name, digestAlgorithm);
    }

    public static Input read(XdmNode node, String name) {
        InputFactory.checkNull(node);
        return new XdmNodeInput(node, name, PSEUDO_NAME_ALGORITHM, name.getBytes());
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

