/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.cmd.CommandLineOptions;
import de.kosit.validationtool.cmd.ReturnValue;
import de.kosit.validationtool.cmd.Validator;
import de.kosit.validationtool.cmd.report.Line;
import de.kosit.validationtool.impl.Printer;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiRenderer;

public class CommandLineApplication {
    private CommandLineApplication() {
    }

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        ReturnValue resultStatus = CommandLineApplication.mainProgram(args);
        if (!resultStatus.equals(ReturnValue.DAEMON_MODE)) {
            CommandLineApplication.sayGoodby(resultStatus);
            System.exit(resultStatus.getCode());
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Printer.writeOut("Shutting down daemon ...", new Object[0])));
        }
    }

    private static void sayGoodby(ReturnValue resultStatus) {
        Printer.writeOut("\n##############################", new Object[0]);
        if (resultStatus.equals(ReturnValue.SUCCESS)) {
            Printer.writeOut("#   " + new Line(AnsiRenderer.Code.GREEN).add("Validation successful!").render(false, false) + "   #", new Object[0]);
        } else {
            Printer.writeOut("#     " + new Line(AnsiRenderer.Code.RED).add("Validation failed!").render(false, false) + "     #", new Object[0]);
        }
        Printer.writeOut("##############################", new Object[0]);
    }

    static ReturnValue mainProgram(String[] args) {
        ReturnValue resultStatus;
        Options options = CommandLineOptions.createOptions();
        try {
            if (CommandLineApplication.isHelpRequested(args)) {
                CommandLineOptions.printHelp(options);
                resultStatus = ReturnValue.SUCCESS;
            } else {
                DefaultParser parser = new DefaultParser();
                CommandLine cmd = parser.parse(options, args);
                CommandLineApplication.configureLogging(cmd);
                resultStatus = Validator.mainProgram(cmd);
            }
        }
        catch (ParseException e) {
            Printer.writeErr("Error processing command line arguments: {0}", new Object[]{e.getMessage(), e});
            CommandLineOptions.printHelp(options);
            resultStatus = ReturnValue.PARSING_ERROR;
        }
        return resultStatus;
    }

    private static boolean isHelpRequested(String[] args) {
        Options helpOptions = CommandLineOptions.createHelpOptions();
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(helpOptions, args, true);
            if (cmd.hasOption(CommandLineOptions.HELP.getOpt()) || args.length == 0) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    private static void configureLogging(CommandLine cmd) throws ParseException {
        if (cmd.hasOption(CommandLineOptions.DEBUG_LOG.getOpt())) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "DEBUG");
        } else if (cmd.hasOption(CommandLineOptions.LOG_LEVEL.getOpt())) {
            String level = Level.resolve(cmd.getOptionValue(CommandLineOptions.LOG_LEVEL.getOpt()));
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", level);
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "OFF");
        }
    }

    private static enum Level {
        INFO,
        WARN,
        DEBUG,
        TRACE,
        ERROR,
        OFF;


        static String resolve(String optionValue) throws ParseException {
            return Arrays.stream(Level.values()).filter(e -> e.name().equalsIgnoreCase(optionValue)).map(Enum::name).findFirst().orElseThrow(() -> new ParseException("Either specify trace,debug,info,warn,error as log level"));
        }
    }
}

