/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CommandLineOptions {
    static final Option HELP = Option.builder((String)"?").longOpt("help").argName("Help").desc("Displays this help").build();
    static final Option SCENARIOS = Option.builder((String)"s").required().longOpt("scenarios").hasArg().desc("Location of scenarios.xml e.g.").build();
    static final Option REPOSITORY = Option.builder((String)"r").longOpt("repository").hasArg().desc("Directory containing scenario content").build();
    static final Option PRINT = Option.builder((String)"p").longOpt("print").desc("Prints the check result to stdout").build();
    static final Option OUTPUT = Option.builder((String)"o").longOpt("output-directory").desc("Defines the out directory for results. Defaults to cwd").hasArg().build();
    static final Option EXTRACT_HTML = Option.builder((String)"h").longOpt("html").desc("Extract and save any html content within  result as a separate file ").build();
    static final Option DEBUG = Option.builder((String)"d").longOpt("debug").desc("Prints some more debug information").build();
    static final Option SERIALIZE_REPORT_INPUT = Option.builder((String)"c").longOpt("serialize-report-input").desc("Serializes the report input to the cwd").build();
    static final Option CHECK_ASSERTIONS = Option.builder((String)"c").longOpt("check-assertions").hasArg().desc("Check the result using defined assertions").argName("assertions-file").build();
    static final Option SERVER = Option.builder((String)"D").longOpt("daemon").desc("Starts a daemon listing for validation requests").build();
    static final Option HOST = Option.builder((String)"H").longOpt("host").hasArg().desc("The hostname / IP address to bind the daemon. Default is localhost").build();
    static final Option PORT = Option.builder((String)"P").longOpt("port").hasArg().desc("The port to bind the daemon. Default is 8080").build();
    static final Option WORKER_COUNT = Option.builder((String)"T").longOpt("threads").hasArg().desc("Number of threads processing validation requests").build();
    static final Option DISABLE_GUI = Option.builder((String)"G").longOpt("disable-gui").desc("Disables the GUI of the daemon mode").build();
    static final Option REPORT_POSTFIX = Option.builder(null).longOpt("report-postfix").hasArg().desc("Postfix of the generated report name").build();
    static final Option REPORT_PREFIX = Option.builder(null).longOpt("report-prefix").hasArg().desc("Prefix of the generated report name").build();
    static final Option DEBUG_LOG = Option.builder((String)"X").longOpt("debug-logging").desc("Enables full debug log. Alias for -l debug").build();
    static final Option LOG_LEVEL = Option.builder((String)"l").longOpt("log-level").hasArg().desc("Enables a certain log level for debugging purposes").build();
    static final Option PRINT_MEM_STATS = Option.builder((String)"m").longOpt("memory-stats").desc("Prints some memory stats").build();

    private CommandLineOptions() {
    }

    static Options createOptions() {
        Options options = new Options();
        options.addOption(HELP);
        options.addOption(SERVER);
        options.addOption(HOST);
        options.addOption(PORT);
        options.addOption(SCENARIOS);
        options.addOption(REPOSITORY);
        options.addOption(PRINT);
        options.addOption(OUTPUT);
        options.addOption(EXTRACT_HTML);
        options.addOption(DEBUG);
        options.addOption(CHECK_ASSERTIONS);
        options.addOption(PRINT_MEM_STATS);
        options.addOption(WORKER_COUNT);
        options.addOption(DISABLE_GUI);
        options.addOption(REPORT_POSTFIX);
        options.addOption(REPORT_PREFIX);
        options.addOption(LOG_LEVEL);
        options.addOption(DEBUG_LOG);
        return options;
    }

    static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("check-tool  -s <scenario-config-file> [OPTIONS] [FILE]... ", options, false);
    }

    static Options createHelpOptions() {
        Options options = new Options();
        options.addOption(HELP);
        return options;
    }
}

