/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd;

import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.api.Input;
import de.kosit.validationtool.api.InputFactory;
import de.kosit.validationtool.api.Result;
import de.kosit.validationtool.cmd.CheckAssertionAction;
import de.kosit.validationtool.cmd.CommandLineOptions;
import de.kosit.validationtool.cmd.DefaultNamingStrategy;
import de.kosit.validationtool.cmd.ExtractHtmlContentAction;
import de.kosit.validationtool.cmd.InternalCheck;
import de.kosit.validationtool.cmd.NamingStrategy;
import de.kosit.validationtool.cmd.PrintMemoryStats;
import de.kosit.validationtool.cmd.PrintReportAction;
import de.kosit.validationtool.cmd.ReturnValue;
import de.kosit.validationtool.cmd.SerializeReportAction;
import de.kosit.validationtool.cmd.SerializeReportInputAction;
import de.kosit.validationtool.cmd.assertions.Assertions;
import de.kosit.validationtool.cmd.assertions.ObjectFactory;
import de.kosit.validationtool.cmd.report.Line;
import de.kosit.validationtool.config.ConfigurationLoader;
import de.kosit.validationtool.daemon.Daemon;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.EngineInformation;
import de.kosit.validationtool.impl.Printer;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.saxon.s9api.Processor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static final Logger log = LoggerFactory.getLogger(Validator.class);

    private Validator() {
    }

    static ReturnValue mainProgram(CommandLine cmd) {
        ReturnValue returnValue;
        Validator.greeting();
        Options options = CommandLineOptions.createOptions();
        try {
            if (cmd.hasOption(CommandLineOptions.SERVER.getOpt())) {
                Validator.startDaemonMode(cmd);
                returnValue = ReturnValue.DAEMON_MODE;
            } else if (cmd.hasOption(CommandLineOptions.HELP.getOpt()) || cmd.getArgList().isEmpty() && !Validator.isPiped()) {
                CommandLineOptions.printHelp(options);
                returnValue = ReturnValue.PARSING_ERROR;
            } else {
                returnValue = Validator.processActions(cmd);
            }
        }
        catch (Exception e) {
            Printer.writeErr(e.getMessage(), new Object[0]);
            if (cmd.hasOption(CommandLineOptions.DEBUG.getOpt())) {
                log.error(e.getMessage(), (Throwable)e);
            } else {
                log.error(e.getMessage());
            }
            return ReturnValue.CONFIGURATION_ERROR;
        }
        return returnValue;
    }

    private static void greeting() {
        Printer.writeOut("{0} version {1}", EngineInformation.getName(), EngineInformation.getVersion());
    }

    private static int determinePort(CommandLine cmd) {
        int port = 8080;
        if (Validator.checkOptionWithValue(CommandLineOptions.PORT, cmd)) {
            port = Integer.parseInt(cmd.getOptionValue(CommandLineOptions.PORT.getOpt()));
        }
        return port;
    }

    private static int determineThreads(CommandLine cmd) {
        int threads = Runtime.getRuntime().availableProcessors();
        if (Validator.checkOptionWithValue(CommandLineOptions.WORKER_COUNT, cmd)) {
            threads = Integer.parseInt(cmd.getOptionValue(CommandLineOptions.WORKER_COUNT.getOpt()));
        }
        return threads;
    }

    private static String determineHost(CommandLine cmd) {
        String host = "localhost";
        if (Validator.checkOptionWithValue(CommandLineOptions.HOST, cmd)) {
            host = cmd.getOptionValue(CommandLineOptions.HOST.getOpt());
        }
        return host;
    }

    private static void startDaemonMode(CommandLine cmd) {
        Option[] unavailable = new Option[]{CommandLineOptions.PRINT, CommandLineOptions.CHECK_ASSERTIONS, CommandLineOptions.DEBUG, CommandLineOptions.OUTPUT, CommandLineOptions.EXTRACT_HTML, CommandLineOptions.REPORT_POSTFIX, CommandLineOptions.REPORT_PREFIX};
        Validator.warnUnusedOptions(cmd, unavailable, true);
        ConfigurationLoader config = Validator.getConfiguration(cmd);
        Daemon validDaemon = new Daemon(Validator.determineHost(cmd), Validator.determinePort(cmd), Validator.determineThreads(cmd));
        if (cmd.hasOption(CommandLineOptions.DISABLE_GUI.getOpt())) {
            validDaemon.setGuiEnabled(false);
        }
        Configuration configuration = config.build();
        Validator.printScenarios(configuration);
        Printer.writeOut("\nStarting daemon mode ...", new Object[0]);
        validDaemon.startServer(configuration);
    }

    private static void warnUnusedOptions(CommandLine cmd, Option[] unavailable, boolean daemon) {
        Arrays.stream(cmd.getOptions()).filter(o -> ArrayUtils.contains((Object[])unavailable, (Object)o)).map(o -> "The option " + o.getLongOpt() + " is not available in daemon mode").forEach(arg_0 -> ((Logger)log).error(arg_0));
        if (daemon && !cmd.getArgList().isEmpty()) {
            log.info("Ignoring test targets in daemon mode");
        }
    }

    private static ReturnValue processActions(CommandLine cmd) throws IOException {
        long start = System.currentTimeMillis();
        Option[] unavailable = new Option[]{CommandLineOptions.HOST, CommandLineOptions.PORT, CommandLineOptions.WORKER_COUNT, CommandLineOptions.DISABLE_GUI};
        Validator.warnUnusedOptions(cmd, unavailable, false);
        Configuration config = Validator.getConfiguration(cmd).build();
        Validator.printScenarios(config);
        InternalCheck check = new InternalCheck(config);
        Path outputDirectory = Validator.determineOutputDirectory(cmd);
        Processor processor = config.getContentRepository().getProcessor();
        if (cmd.hasOption(CommandLineOptions.EXTRACT_HTML.getOpt())) {
            check.getCheckSteps().add(new ExtractHtmlContentAction(processor, outputDirectory));
        }
        check.getCheckSteps().add(new SerializeReportAction(outputDirectory, processor, Validator.determineNamingStrategy(cmd)));
        if (cmd.hasOption(CommandLineOptions.SERIALIZE_REPORT_INPUT.getOpt())) {
            check.getCheckSteps().add(new SerializeReportInputAction(outputDirectory, check.getConversionService()));
        }
        if (cmd.hasOption(CommandLineOptions.PRINT.getOpt())) {
            check.getCheckSteps().add(new PrintReportAction(processor));
        }
        if (cmd.hasOption(CommandLineOptions.CHECK_ASSERTIONS.getOpt())) {
            Assertions assertions = Validator.loadAssertions(cmd.getOptionValue(CommandLineOptions.CHECK_ASSERTIONS.getOpt()));
            check.getCheckSteps().add(new CheckAssertionAction(assertions, processor));
        }
        if (cmd.hasOption(CommandLineOptions.PRINT_MEM_STATS.getOpt())) {
            check.getCheckSteps().add(new PrintMemoryStats());
        }
        log.info("Setup completed in {}ms\n", (Object)(System.currentTimeMillis() - start));
        Collection<Input> targets = Validator.determineTestTargets(cmd);
        start = System.currentTimeMillis();
        HashMap<String, Result> results = new HashMap<String, Result>();
        Printer.writeOut("\nProcessing of {0} objects started", targets.size());
        long tick = System.currentTimeMillis();
        for (Input input : targets) {
            results.put(input.getName(), check.checkInput(input));
            if ((System.currentTimeMillis() - tick) / 1000L <= 5L) continue;
            tick = System.currentTimeMillis();
            Printer.writeOut("{0}/{1} objects processed", results.size(), targets.size());
        }
        long processingTime = System.currentTimeMillis() - start;
        Printer.writeOut("Processing of {0} objects completed in {1}ms", targets.size(), processingTime);
        check.printResults(results);
        log.info("Processing {} object(s) completed in {}ms", (Object)targets.size(), (Object)processingTime);
        return check.isSuccessful(results) ? ReturnValue.SUCCESS : ReturnValue.createFailed(check.getNotAcceptableCount(results));
    }

    private static ConfigurationLoader getConfiguration(CommandLine cmd) {
        URI scenarioLocation = Validator.determineDefinition(cmd);
        URI repositoryLocation = Validator.determineRepository(cmd);
        Validator.reportConfiguration(scenarioLocation, repositoryLocation);
        return Configuration.load(scenarioLocation, repositoryLocation);
    }

    private static void reportConfiguration(URI scenarioLocation, URI repositoryLocation) {
        Printer.writeOut("Loading scenarios from  {0}", scenarioLocation);
        Printer.writeOut("Using repository  {0}", repositoryLocation);
    }

    private static void printScenarios(Configuration configuration) {
        Printer.writeOut("Loaded \"{0}\" by {1} from {2} ", configuration.getName(), configuration.getAuthor(), configuration.getDate());
        Printer.writeOut("\nThe following scenarios are available:", new Object[0]);
        configuration.getScenarios().forEach(e -> {
            Line line = new Line(AnsiRenderer.Code.GREEN);
            line.add("  * " + e.getName());
            Printer.writeOut(line.render(false, false), new Object[0]);
        });
    }

    private static NamingStrategy determineNamingStrategy(CommandLine cmd) {
        DefaultNamingStrategy namingStrategy = new DefaultNamingStrategy();
        if (cmd.hasOption(CommandLineOptions.REPORT_PREFIX.getLongOpt())) {
            namingStrategy.setPrefix(cmd.getOptionValue(CommandLineOptions.REPORT_PREFIX.getLongOpt()));
        }
        if (cmd.hasOption(CommandLineOptions.REPORT_POSTFIX.getLongOpt())) {
            namingStrategy.setPostfix(cmd.getOptionValue(CommandLineOptions.REPORT_POSTFIX.getLongOpt()));
        }
        return namingStrategy;
    }

    private static Assertions loadAssertions(String optionValue) {
        Path p = Paths.get(optionValue, new String[0]);
        Assertions a = null;
        if (Files.exists(p, new LinkOption[0])) {
            ConversionService c = new ConversionService();
            c.initialize(ObjectFactory.class.getPackage());
            a = c.readXml(p.toUri(), Assertions.class);
        }
        return a;
    }

    private static Path determineOutputDirectory(CommandLine cmd) {
        Path fir;
        String value = cmd.getOptionValue(CommandLineOptions.OUTPUT.getOpt());
        if (StringUtils.isNotBlank((CharSequence)value)) {
            fir = Paths.get(value, new String[0]);
            if (!Files.exists(fir, new LinkOption[0]) && !fir.toFile().mkdirs() || !Files.isDirectory(fir, new LinkOption[0])) {
                throw new IllegalStateException(String.format("Invalid target directory %s specified", value));
            }
        } else {
            fir = Paths.get("", new String[0]);
        }
        return fir;
    }

    private static Collection<Input> determineTestTargets(CommandLine cmd) throws IOException {
        ArrayList<Input> targets = new ArrayList<Input>();
        if (!cmd.getArgList().isEmpty()) {
            cmd.getArgList().forEach(e -> targets.addAll(Validator.determineTestTarget(e)));
        }
        if (Validator.isPiped()) {
            targets.add(Validator.readFromPipe());
        }
        if (targets.isEmpty()) {
            throw new IllegalStateException("No test targets found. Nothing to check. Will quit now!");
        }
        return targets;
    }

    private static boolean isPiped() throws IOException {
        return System.in.available() > 0;
    }

    private static Input readFromPipe() {
        return InputFactory.read(System.in, "stdin");
    }

    private static Collection<Input> determineTestTarget(String s) {
        Path d = Paths.get(s, new String[0]);
        if (Files.isDirectory(d, new LinkOption[0])) {
            return Validator.listDirectoryTargets(d);
        }
        if (Files.exists(d, new LinkOption[0])) {
            return Collections.singleton(InputFactory.read(d));
        }
        log.warn("The specified test target {} does not exist. Will be ignored", (Object)s);
        return Collections.emptyList();
    }

    private static Collection<Input> listDirectoryTargets(Path d) {
        Collection collection;
        block8: {
            Stream<Path> stream = Files.list(d);
            try {
                collection = stream.filter(path -> path.toString().toLowerCase().endsWith(".xml")).map(InputFactory::read).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("IOException while list directory content. Can not determine test targets.", e);
                }
            }
            stream.close();
        }
        return collection;
    }

    private static URI determineRepository(CommandLine cmd) {
        if (Validator.checkOptionWithValue(CommandLineOptions.REPOSITORY, cmd)) {
            Path d = Paths.get(cmd.getOptionValue(CommandLineOptions.REPOSITORY.getOpt()), new String[0]);
            if (Files.isDirectory(d, new LinkOption[0])) {
                return d.toUri();
            }
            throw new IllegalArgumentException(String.format("Not a valid path for repository definition specified: '%s'", d.toAbsolutePath()));
        }
        return null;
    }

    private static URI determineDefinition(CommandLine cmd) {
        Validator.checkOptionWithValue(CommandLineOptions.SCENARIOS, cmd);
        Path f = Paths.get(cmd.getOptionValue(CommandLineOptions.SCENARIOS.getOpt()), new String[0]);
        if (Files.isRegularFile(f, new LinkOption[0])) {
            return f.toAbsolutePath().toUri();
        }
        throw new IllegalArgumentException(String.format("Not a valid path for scenario definition specified: '%s'", f.toAbsolutePath()));
    }

    private static boolean checkOptionWithValue(Option option, CommandLine cmd) {
        String opt = option.getOpt();
        if (cmd.hasOption(opt)) {
            String value = cmd.getOptionValue(opt);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
                return true;
            }
            throw new IllegalArgumentException(String.format("Option value required for Option '%s'", option.getLongOpt()));
        }
        if (option.isRequired()) {
            throw new IllegalArgumentException(String.format("Option '%s' required ", option.getLongOpt()));
        }
        return false;
    }
}

