/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.fusesource.jansi.AnsiRenderer;

public class Format {
    private AnsiRenderer.Code textColor;
    private AnsiRenderer.Code background;
    private final Set<AnsiRenderer.Code> codes = new HashSet<AnsiRenderer.Code>();

    public AnsiRenderer.Code[] mergeCodes(Collection<AnsiRenderer.Code> newCodes) {
        return this.mergeCodes(newCodes.toArray(new AnsiRenderer.Code[newCodes.size()]));
    }

    public AnsiRenderer.Code[] mergeCodes(AnsiRenderer.Code ... newCodes) {
        AnsiRenderer.Code[] allCodes = (AnsiRenderer.Code[])ArrayUtils.addAll((Object[])((AnsiRenderer.Code[])ArrayUtils.addAll((Object[])this.codes.toArray(new AnsiRenderer.Code[0]), (Object[])newCodes)), (Object[])new AnsiRenderer.Code[]{this.textColor, this.background});
        Optional<AnsiRenderer.Code> color = Arrays.stream(allCodes).filter(Objects::nonNull).filter(AnsiRenderer.Code::isColor).findFirst();
        Optional<AnsiRenderer.Code> bg = Arrays.stream(allCodes).filter(Objects::nonNull).filter(AnsiRenderer.Code::isBackground).findFirst();
        List attributes = Arrays.stream(allCodes).filter(Objects::nonNull).filter(AnsiRenderer.Code::isBackground).filter(AnsiRenderer.Code::isColor).collect(Collectors.toList());
        attributes.add(color.orElse(this.textColor));
        attributes.add(bg.orElse(this.background));
        return (AnsiRenderer.Code[])attributes.stream().filter(Objects::nonNull).toArray(AnsiRenderer.Code[]::new);
    }

    public Format color(AnsiRenderer.Code textColor) {
        this.textColor = textColor;
        return this;
    }

    public Format background(AnsiRenderer.Code color) {
        this.background = color;
        return this;
    }

    public Format addCodes(AnsiRenderer.Code ... codes) {
        this.codes.addAll(Arrays.asList(codes));
        return this;
    }

    public AnsiRenderer.Code getTextColor() {
        return this.textColor;
    }

    public AnsiRenderer.Code getBackground() {
        return this.background;
    }

    public Set<AnsiRenderer.Code> getCodes() {
        return this.codes;
    }
}

