/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd.report;

import de.kosit.validationtool.cmd.report.Format;
import de.kosit.validationtool.cmd.report.Justify;
import de.kosit.validationtool.cmd.report.Line;
import de.kosit.validationtool.cmd.report.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiRenderer;

public class Grid {
    private static final Format DEFAULT_FORMAT = new Format();
    private final List<ColumnDefinition> definitions = new ArrayList<ColumnDefinition>();
    private final List<Cell> values = new ArrayList<Cell>();

    public Grid(ColumnDefinition ... def) {
        Stream.of(def).forEach(this::addColumn);
    }

    private String generateGridStart() {
        return IntStream.range(0, this.getLineLength() + this.definitions.size()).mapToObj(i -> "-").collect(Collectors.joining("")) + "\n";
    }

    private String generateGridEnd() {
        return IntStream.range(0, this.getLineLength() + this.definitions.size()).mapToObj(i -> "-").collect(Collectors.joining("")) + "\n";
    }

    private String generateHeader() {
        return "|" + this.definitions.stream().map(d -> StringUtils.rightPad((String)d.getName(), (int)d.getLength())).collect(Collectors.joining("|")) + "|\n";
    }

    public Grid addColumn(ColumnDefinition def) {
        this.definitions.add(def);
        return this;
    }

    private void calculateLength() {
        IntStream.range(0, this.definitions.size()).forEach(i -> {
            ColumnDefinition def = this.definitions.get(i);
            List<Cell> column = this.getColumn(i);
            int maxLength = column.stream().mapToInt(cell -> cell.getText().stream().mapToInt(Text::getLength).sum()).max().orElse(0);
            def.setLength(Math.max(maxLength, def.getName().length()));
        });
    }

    public List<Cell> getColumn(int index) {
        return IntStream.range(0, this.values.size()).filter(n -> n % this.definitions.size() == index).mapToObj(this.values::get).collect(Collectors.toList());
    }

    public Grid addCell(Cell cell) {
        this.values.add(cell);
        return this;
    }

    public Grid addCell(Text ... text) {
        return this.addCell(new Cell(Arrays.asList(text)));
    }

    public Grid addCell(Object cell, AnsiRenderer.Code ... codes) {
        Format f = new Format();
        f.addCodes(codes);
        Text t = new Text(cell, f);
        return this.addCell(new Cell(t));
    }

    public Grid addCell(Object cell) {
        return this.addCell(cell, DEFAULT_FORMAT.getTextColor());
    }

    private Collection<List<Cell>> prepareLines() {
        AtomicInteger counter = new AtomicInteger();
        int chunkSize = this.definitions.size();
        return this.values.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / chunkSize)).values();
    }

    public String render() {
        StringBuilder b = new StringBuilder();
        this.calculateLength();
        b.append(this.generateGridStart());
        b.append(this.generateHeader());
        this.prepareLines().forEach(line -> b.append(this.printLine((List<Cell>)line)));
        b.append(this.generateGridEnd());
        return b.toString();
    }

    private String printLine(List<Cell> line) {
        StringBuilder b = new StringBuilder();
        int virtualLine = 0;
        while (true) {
            StringBuilder current = new StringBuilder();
            int bound = this.definitions.size();
            for (int i = 0; i < bound; ++i) {
                ColumnDefinition def = this.definitions.get(i);
                current.append("|");
                current.append(line.get(i).render(virtualLine, def));
            }
            current.append("|");
            if (Grid.isEmpty(current) || virtualLine >= this.getMaxVirtualLine()) break;
            b.append(current.toString());
            ++virtualLine;
            b.append("\n");
        }
        return b.toString();
    }

    private static boolean isEmpty(StringBuilder current) {
        return current.toString().replaceAll("\\|", "").trim().length() == 0;
    }

    private int getMaxVirtualLine() {
        return this.definitions.stream().mapToInt(ColumnDefinition::getMaxLines).max().orElseThrow(IllegalAccessError::new);
    }

    private int getLineLength() {
        return this.definitions.stream().map(ColumnDefinition::getLength).reduce(0, Integer::sum);
    }

    static /* synthetic */ Format access$000() {
        return DEFAULT_FORMAT;
    }

    private static class Cell {
        private final Format format = Grid.access$000();
        private final List<Text> text;

        public Cell(Text txt) {
            this.text = new ArrayList<Text>();
            this.text.add(txt);
        }

        public Cell(Object object, AnsiRenderer.Code ... codes) {
            this(new Text(object, codes));
        }

        protected Line getFormattedLine(int lineNumber, ColumnDefinition def) {
            Line line = new Line();
            int startSubstring = lineNumber * def.getLength();
            int currentVisibleLength = 0;
            for (Text t : this.text) {
                String part = t.getVisibleText(startSubstring, def.getLength());
                currentVisibleLength += part.length();
                if (StringUtils.isNotBlank((CharSequence)part)) {
                    line.add((Object)part, t.getFormat());
                    if (currentVisibleLength >= def.getLength()) break;
                    startSubstring = 0;
                    continue;
                }
                startSubstring -= t.getLength();
            }
            return line;
        }

        protected List<Line> getFormattedLines(ColumnDefinition def) {
            Line line;
            int count = 0;
            ArrayList<Line> lines = new ArrayList<Line>();
            while ((line = this.getFormattedLine(count++, def)).isNotEmpty()) {
                lines.add(line);
            }
            return lines;
        }

        public String render(int row, ColumnDefinition def) {
            Line line;
            List<Line> test = this.getFormattedLines(def);
            Line line2 = line = test.size() > row ? test.get(row) : null;
            if (line != null) {
                return def.getJustify().apply(line.render(false, row == def.getMaxLines() - 1 && test.size() > def.getMaxLines()), def.getLength() + (line.getLength() - line.getVisibleLength()));
            }
            return def.getJustify().apply("", def.getLength());
        }

        public Cell add(Object object, AnsiRenderer.Code ... codes) {
            this.text.add(new Text(object, codes));
            return this;
        }

        public Cell(List<Text> text) {
            this.text = text;
        }

        public Format getFormat() {
            return this.format;
        }

        public List<Text> getText() {
            return this.text;
        }
    }

    public static class ColumnDefinition {
        private static final int MAX_LENGTH = 80;
        private final String name;
        private int length = 0;
        private final int maxLength;
        private final int minLength;
        private final int maxLines;
        private Justify justify = Justify.LEFT;

        public ColumnDefinition(String name) {
            this(name, -1, -1, 1);
        }

        public ColumnDefinition(String name, int maxLength) {
            this(name, maxLength, -1, 1);
        }

        public ColumnDefinition(String name, int maxLength, int minLength) {
            this(name, maxLength, minLength, 1);
        }

        public ColumnDefinition(String name, int maxLength, int minLength, int maxLines) {
            this.name = name;
            this.maxLength = maxLength;
            this.minLength = minLength;
            this.maxLines = maxLines;
        }

        public int getLength() {
            if (this.minLength > 0 && this.minLength > this.length) {
                return this.minLength;
            }
            if (this.maxLength > 0 && this.length > this.maxLength) {
                return this.maxLength;
            }
            return this.length;
        }

        public void setLength(int length) {
            if (length > this.length) {
                this.length = length;
            }
            if (length > 80) {
                this.length = 80;
            }
        }

        public ColumnDefinition justify(Justify justify) {
            this.justify = justify;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public int getMinLength() {
            return this.minLength;
        }

        public int getMaxLines() {
            return this.maxLines;
        }

        public Justify getJustify() {
            return this.justify;
        }
    }
}

