/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.cmd.report;

import de.kosit.validationtool.cmd.report.Format;
import de.kosit.validationtool.cmd.report.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.AnsiRenderer;

public class Line {
    private final List<Text> texts = new ArrayList<Text>();
    private Format baseFormat = new Format();

    public Line(Format format) {
        this.baseFormat = format;
    }

    public Line(AnsiRenderer.Code ... codes) {
        this(new Format().addCodes(codes));
    }

    public Line add(Text text) {
        this.texts.add(text);
        return this;
    }

    public Line add(Object t) {
        return this.add(new Text(t));
    }

    public Line add(Object text, AnsiRenderer.Code ... codes) {
        return this.add(new Text(text, codes));
    }

    public Line add(Object text, Format format) {
        return this.add(new Text(text, format));
    }

    public String render() {
        return this.render(true, false);
    }

    public String render(boolean newLine, boolean dotted) {
        ArrayList<String> joins = new ArrayList<String>();
        ArrayList<Text> reversed = new ArrayList<Text>(this.texts);
        int replace = 0;
        Collections.reverse(reversed);
        if (dotted && this.getVisibleLength() > replace) {
            replace = 3;
        }
        for (Text t : reversed) {
            if (replace > 0) {
                String render = t.render(t.getVisibleText(0, t.getVisibleLength() - replace), this.baseFormat);
                if (StringUtils.isNotEmpty((CharSequence)render)) {
                    joins.add(render);
                }
                replace -= t.getVisibleLength();
                continue;
            }
            joins.add(t.render(this.baseFormat));
        }
        Collections.reverse(joins);
        return String.join((CharSequence)" ", joins) + (dotted ? "..." : "") + (newLine ? "\n" : "");
    }

    public int getLength() {
        return this.texts.stream().mapToInt(Text::getLength).sum();
    }

    public static String render(String text, AnsiRenderer.Code ... codes) {
        return new Line().add((Object)text, codes).render();
    }

    public boolean isNotEmpty() {
        return !this.texts.isEmpty();
    }

    public int getVisibleLength() {
        return this.texts.stream().mapToInt(Text::getVisibleLength).sum();
    }

    public Line() {
    }
}

