/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.config.Builder;
import de.kosit.validationtool.config.ReportBuilder;
import de.kosit.validationtool.config.SchemaBuilder;
import de.kosit.validationtool.config.SchematronBuilder;
import de.kosit.validationtool.config.XPathBuilder;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.model.scenarios.CreateReportType;
import de.kosit.validationtool.model.scenarios.DescriptionType;
import de.kosit.validationtool.model.scenarios.NamespaceType;
import de.kosit.validationtool.model.scenarios.ObjectFactory;
import de.kosit.validationtool.model.scenarios.ScenarioType;
import de.kosit.validationtool.model.scenarios.ValidateWithSchematron;
import de.kosit.validationtool.model.scenarios.ValidateWithXmlSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.validation.Schema;
import net.sf.saxon.s9api.XPathExecutable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioBuilder
implements Builder<Scenario> {
    private static final Logger log = LoggerFactory.getLogger(ScenarioBuilder.class);
    private static int nameCount = 0;
    private static final String DEFAULT_DESCRIPTION = "Dieses Scenario wurde per API erstellt";
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final XPathBuilder matchConfig = new XPathBuilder("match");
    private final XPathBuilder acceptConfig = new XPathBuilder("accept");
    private String name;
    private SchemaBuilder schemaBuilder;
    private final List<SchematronBuilder> schematronBuilders = new ArrayList<SchematronBuilder>();
    private ReportBuilder reportBuilder;
    private String description;

    @Override
    public Result<Scenario, String> build(ContentRepository repository) {
        ArrayList<String> errors = new ArrayList<String>();
        Scenario scenario = new Scenario(this.createType());
        this.buildMatch(repository, errors, scenario);
        this.buildSchema(repository, errors, scenario);
        this.buildSchematron(repository, errors, scenario);
        this.buildReport(repository, errors, scenario);
        this.buildAccept(repository, errors, scenario);
        this.buildNamespaces(scenario);
        return new Result<Scenario, String>(scenario, errors);
    }

    public ScenarioBuilder match(XPathExecutable executable) {
        this.matchConfig.setExecutable(executable);
        return this;
    }

    public ScenarioBuilder match(String xpath) {
        this.matchConfig.setXpath(xpath);
        return this;
    }

    public ScenarioBuilder declareNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        return this;
    }

    public ScenarioBuilder acceptWith(XPathExecutable executable) {
        this.acceptConfig.setExecutable(executable);
        return this;
    }

    public ScenarioBuilder acceptWith(String acceptXpath) {
        this.acceptConfig.setXpath(acceptXpath);
        return this;
    }

    public ScenarioBuilder validate(SchematronBuilder schematron) {
        if (schematron != null) {
            this.schematronBuilders.add(schematron);
        }
        return this;
    }

    public ScenarioBuilder validate(SchemaBuilder schema) {
        this.schemaBuilder = schema;
        return this;
    }

    public ScenarioBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ScenarioBuilder with(ReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
        return this;
    }

    private static String generateName() {
        return "manually created scenario " + nameCount++;
    }

    private void buildNamespaces(Scenario scenario) {
        this.namespaces.putAll(this.acceptConfig.getNamespaces());
        this.namespaces.putAll(this.matchConfig.getNamespaces());
        List all = this.namespaces.entrySet().stream().map(e -> {
            NamespaceType n = new NamespaceType();
            n.setPrefix((String)e.getKey());
            n.setValue((String)e.getValue());
            return n;
        }).collect(Collectors.toList());
        scenario.getConfiguration().getNamespace().addAll(all);
    }

    private void buildMatch(ContentRepository repository, List<String> errors, Scenario scenario) {
        this.matchConfig.setNamespaces(this.namespaces);
        Result<XPathExecutable, String> result = this.matchConfig.build(repository);
        if (result.isValid()) {
            scenario.setMatchExecutable(result.getObject());
            scenario.getConfiguration().setMatch(this.matchConfig.getXPath());
            this.namespaces.putAll(this.matchConfig.getNamespaces());
        } else {
            errors.addAll(result.getErrors());
        }
    }

    private void buildAccept(ContentRepository repository, List<String> errors, Scenario scenario) {
        this.acceptConfig.setNamespaces(this.namespaces);
        if (this.acceptConfig.isAvailable()) {
            Result<XPathExecutable, String> result = this.acceptConfig.build(repository);
            if (result.isValid()) {
                scenario.setAcceptExecutable(result.getObject());
                scenario.getConfiguration().setAcceptMatch(this.acceptConfig.getXPath());
                this.namespaces.putAll(this.acceptConfig.getNamespaces());
            } else {
                errors.addAll(result.getErrors());
            }
        } else {
            log.debug("No accept configuration available");
        }
    }

    private void buildReport(ContentRepository repository, List<String> errors, Scenario scenario) {
        if (this.reportBuilder == null) {
            errors.add("Must supply report configuration");
        } else {
            Result<Pair<CreateReportType, Scenario.Transformation>, String> result = this.reportBuilder.build(repository);
            if (result.isValid()) {
                scenario.setReportTransformation((Scenario.Transformation)result.getObject().getRight());
                scenario.getConfiguration().setCreateReport((CreateReportType)result.getObject().getLeft());
            } else {
                errors.addAll(result.getErrors());
            }
        }
    }

    private void buildSchematron(ContentRepository repository, List<String> errors, Scenario scenario) {
        this.schematronBuilders.forEach(e -> {
            Result<Pair<ValidateWithSchematron, Scenario.Transformation>, String> result = e.build(repository);
            if (result.isValid()) {
                scenario.getConfiguration().getValidateWithSchematron().add((ValidateWithSchematron)result.getObject().getLeft());
                scenario.getSchematronValidations().add((Scenario.Transformation)result.getObject().getRight());
            } else {
                errors.addAll(result.getErrors());
            }
        });
    }

    private void buildSchema(ContentRepository repository, List<String> errors, Scenario scenario) {
        if (this.schemaBuilder == null) {
            errors.add("Must supply schema for validation");
        } else {
            Result<Pair<ValidateWithXmlSchema, Schema>, String> result = this.schemaBuilder.build(repository);
            if (result.isValid()) {
                scenario.setSchema((Schema)result.getObject().getRight());
                scenario.getConfiguration().setValidateWithXmlSchema((ValidateWithXmlSchema)result.getObject().getLeft());
            } else {
                errors.addAll(result.getErrors());
            }
        }
    }

    private ScenarioType createType() {
        ScenarioType type = new ScenarioType();
        type.setName(ObjectUtils.isNotEmpty((Object)this.name) ? this.name : ScenarioBuilder.generateName());
        DescriptionType desc = new DescriptionType();
        desc.getPOrOlOrUl().add(new ObjectFactory().createDescriptionTypeP((String)StringUtils.defaultIfBlank((CharSequence)this.description, (CharSequence)DEFAULT_DESCRIPTION)));
        type.setDescription(desc);
        return type;
    }

    public ScenarioBuilder name(String name) {
        this.name = name;
        return this;
    }

    Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    XPathBuilder getMatchConfig() {
        return this.matchConfig;
    }

    XPathBuilder getAcceptConfig() {
        return this.acceptConfig;
    }

    String getName() {
        return this.name;
    }

    SchemaBuilder getSchemaBuilder() {
        return this.schemaBuilder;
    }

    List<SchematronBuilder> getSchematronBuilders() {
        return this.schematronBuilders;
    }

    ReportBuilder getReportBuilder() {
        return this.reportBuilder;
    }

    String getDescription() {
        return this.description;
    }
}

