/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.config;

import de.kosit.validationtool.config.Builder;
import de.kosit.validationtool.impl.ContentRepository;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.model.Result;
import de.kosit.validationtool.model.scenarios.ResourceType;
import de.kosit.validationtool.model.scenarios.ValidateWithSchematron;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronBuilder
implements Builder<Pair<ValidateWithSchematron, Scenario.Transformation>> {
    private static final Logger log = LoggerFactory.getLogger(SchematronBuilder.class);
    private static final String DEFAULT_NAME = "manually configured";
    private XsltExecutable executable;
    private URI source;
    private String name;

    @Override
    public Result<Pair<ValidateWithSchematron, Scenario.Transformation>, String> build(ContentRepository repository) {
        Result<Object, Object> result;
        if (this.executable == null && this.source == null) {
            return SchematronBuilder.createError(String.format("Must supply source location and/or executable for schematron '%s'", this.name));
        }
        ValidateWithSchematron object = this.createObject();
        try {
            if (this.executable == null) {
                this.executable = repository.createSchematronTransformation(object).getExecutable();
            }
            result = new Result(new ImmutablePair((Object)object, (Object)new Scenario.Transformation(this.executable, object.getResource())));
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage(), (Throwable)e);
            result = SchematronBuilder.createError(String.format("Can not create schematron configuration based  on %s. Exception is %s", this.source, e.getMessage()));
        }
        return result;
    }

    private ValidateWithSchematron createObject() {
        ValidateWithSchematron o = new ValidateWithSchematron();
        ResourceType r = new ResourceType();
        r.setLocation(this.source.toASCIIString());
        r.setName(ObjectUtils.isNotEmpty((Object)this.name) ? this.name : DEFAULT_NAME);
        o.setResource(r);
        return o;
    }

    private static Result<Pair<ValidateWithSchematron, Scenario.Transformation>, String> createError(String msg) {
        return new Result<Object, String>(null, Collections.singletonList(msg));
    }

    public SchematronBuilder source(String source) {
        return this.source(URI.create(source));
    }

    public SchematronBuilder source(URI source) {
        this.source = source;
        return this;
    }

    public SchematronBuilder source(Path source) {
        return this.source(source.toUri());
    }

    public SchematronBuilder name(String name) {
        this.name = name;
        return this;
    }
}

