/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.daemon;

import com.sun.net.httpserver.HttpExchange;
import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.daemon.BaseHandler;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.model.scenarios.Scenarios;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigHandler
extends BaseHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfigHandler.class);
    private final Configuration configuration;
    private final ConversionService conversionService;

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            Optional<String> xml = this.getSource();
            if (xml.isPresent()) {
                ConfigHandler.write(exchange, xml.get().getBytes(), "application/xml");
            } else {
                ConfigHandler.error(exchange, 404, "No configuration found");
            }
        }
        catch (Exception e) {
            log.error("Error grabbing configuration", (Throwable)e);
            ConfigHandler.error(exchange, 500, "Error grabbing configuration: " + e.getMessage());
        }
    }

    private Optional<String> getSource() {
        URI fileUri = (URI)this.configuration.getAdditionalParameters().get("scenarios_file");
        return fileUri != null ? ConfigHandler.loadFile(fileUri) : this.loadFromConfig();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> loadFile(URI fileUri) {
        try (InputStreamReader in = new InputStreamReader(fileUri.toURL().openStream());){
            Optional<String> optional;
            try (StringWriter out = new StringWriter();){
                IOUtils.copy((Reader)in, (Writer)out);
                optional = Optional.of(out.toString());
            }
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private Optional<String> loadFromConfig() {
        Optional<String> result;
        Scenarios scenarios = (Scenarios)this.configuration.getAdditionalParameters().get("scenario_definition");
        if (scenarios != null) {
            String s = this.conversionService.writeXml(scenarios);
            result = Optional.of(s);
        } else {
            result = Optional.empty();
        }
        return result;
    }

    public ConfigHandler(Configuration configuration, ConversionService conversionService) {
        this.configuration = configuration;
        this.conversionService = conversionService;
    }
}

