/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.daemon;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.kosit.validationtool.api.Configuration;
import de.kosit.validationtool.daemon.BaseHandler;
import de.kosit.validationtool.daemon.CheckHandler;
import de.kosit.validationtool.daemon.ConfigHandler;
import de.kosit.validationtool.daemon.GuiHandler;
import de.kosit.validationtool.daemon.HealthHandler;
import de.kosit.validationtool.daemon.RoutingHandler;
import de.kosit.validationtool.impl.ConversionService;
import de.kosit.validationtool.impl.DefaultCheck;
import de.kosit.validationtool.impl.Printer;
import de.kosit.validationtool.model.daemon.HealthType;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Daemon {
    private static final Logger log = LoggerFactory.getLogger(Daemon.class);
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    private String bindAddress;
    private int port;
    private int threadCount;
    private boolean guiEnabled = true;

    public Daemon(String hostname, int port, int threadCount) {
        this.bindAddress = hostname;
        this.port = port;
        this.threadCount = threadCount;
    }

    public void startServer(Configuration config) {
        HttpServer server = null;
        try {
            ConversionService healthConverter = new ConversionService();
            healthConverter.initialize(HealthType.class.getPackage());
            ConversionService converter = new ConversionService();
            server = HttpServer.create(this.getSocket(), 0);
            server.createContext("/", this.createRootHandler(config));
            server.createContext("/server/health", new HealthHandler(config, healthConverter));
            server.createContext("/server/config", new ConfigHandler(config, converter));
            server.setExecutor(this.createExecutor());
            server.start();
            log.info("Server {} started", (Object)server.getAddress());
            Printer.writeOut("Daemon started. Visit http://{0}", this.bindAddress + ":" + this.port);
        }
        catch (IOException e) {
            log.error("Error starting HttpServer for Valdidator: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private HttpHandler createRootHandler(Configuration config) {
        BaseHandler rootHandler;
        DefaultCheck check = new DefaultCheck(config);
        CheckHandler checkHandler = new CheckHandler(check, config.getContentRepository().getProcessor());
        if (this.guiEnabled) {
            GuiHandler gui = new GuiHandler();
            rootHandler = new RoutingHandler(checkHandler, gui);
        } else {
            rootHandler = checkHandler;
        }
        return rootHandler;
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.threadCount > 0 ? this.threadCount : Runtime.getRuntime().availableProcessors());
    }

    private InetSocketAddress getSocket() {
        return new InetSocketAddress((String)StringUtils.defaultIfBlank((CharSequence)this.bindAddress, (CharSequence)DEFAULT_HOST), this.port > 0 ? this.port : 8080);
    }

    public Daemon() {
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setGuiEnabled(boolean guiEnabled) {
        this.guiEnabled = guiEnabled;
    }
}

