/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.daemon;

import com.sun.net.httpserver.HttpExchange;
import de.kosit.validationtool.daemon.BaseHandler;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class GuiHandler
extends BaseHandler {
    private static final URL INDEX_HTML = GuiHandler.class.getClassLoader().getResource("gui/index.html");

    public GuiHandler() {
        if (INDEX_HTML == null) {
            throw new IllegalStateException("No html found");
        }
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        assert (INDEX_HTML != null);
        String path = exchange.getRequestURI().toASCIIString();
        if (path.equals("/")) {
            GuiHandler.write(exchange, IOUtils.toString((URL)INDEX_HTML, (Charset)Charset.defaultCharset()).getBytes(), "text/html");
        } else {
            URL resource = GuiHandler.class.getClassLoader().getResource("gui" + path);
            if (resource != null) {
                GuiHandler.write(exchange, IOUtils.toString((URL)resource, (Charset)Charset.defaultCharset()).getBytes(), Mediatype.resolveBySuffix(resource.getPath()).getMimeType());
            } else {
                GuiHandler.error(exchange, 404, "not found");
            }
        }
    }

    protected static enum Mediatype {
        JS("application/javascript"),
        MD("text/markdown"),
        CSS("text/css");

        private final String mimeType;

        static Mediatype resolveBySuffix(String path) {
            return Arrays.stream(Mediatype.values()).filter(e -> path.toUpperCase().endsWith("." + e.name())).findFirst().orElse(MD);
        }

        private Mediatype(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

