/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.impl.xml.RelativeUriResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class ClassPathResourceResolver
implements LSResourceResolver {
    private static final Logger log = LoggerFactory.getLogger(ClassPathResourceResolver.class);
    private final URI base;

    public ClassPathResourceResolver(String basePath) {
        if (!StringUtils.startsWith((CharSequence)basePath, (CharSequence)"/")) {
            throw new IllegalArgumentException("Base path must start with a slash");
        }
        this.base = URI.create(basePath + (basePath.endsWith("/") == basePath.length() > 1 ? "" : "/"));
    }

    public ClassPathResourceResolver(URI jarUri) {
        this.base = jarUri;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        URI resolved = RelativeUriResolver.resolve(URI.create(systemId), this.base);
        if (resolved != null) {
            try {
                URL resource = resolved.isAbsolute() ? resolved.toURL() : ClassPathResourceResolver.class.getResource(resolved.toASCIIString());
                LSInputImpl input = new LSInputImpl(publicId, systemId, resolved.toASCIIString());
                InputStream in = resource.openStream();
                input.setByteStream(in);
                return input;
            }
            catch (IOException e) {
                log.error("Error loading schema resource from {}", (Object)resolved, (Object)e);
            }
        }
        return null;
    }

    private static class LSInputImpl
    implements LSInput {
        private Reader characterStream;
        private InputStream byteStream;
        private String systemId;
        private String publicId;
        private String baseURI;
        private String encoding;
        private boolean certifiedText;
        private String stringData;

        public LSInputImpl(String publicId, String systemId, String baseURI) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseURI = baseURI;
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        public LSInputImpl() {
        }
    }
}

