/*
 * Decompiled with CFR 0.152.
 */
package de.kosit.validationtool.impl;

import de.kosit.validationtool.api.ResolvingConfigurationStrategy;
import de.kosit.validationtool.impl.ClassPathResourceResolver;
import de.kosit.validationtool.impl.CollectingErrorEventHandler;
import de.kosit.validationtool.impl.Scenario;
import de.kosit.validationtool.impl.xml.RelativeUriResolver;
import de.kosit.validationtool.impl.xml.StringTrimAdapter;
import de.kosit.validationtool.model.scenarios.NamespaceType;
import de.kosit.validationtool.model.scenarios.ResourceType;
import de.kosit.validationtool.model.scenarios.ScenarioType;
import de.kosit.validationtool.model.scenarios.ValidateWithSchematron;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ContentRepository {
    private static final Logger log = LoggerFactory.getLogger(ContentRepository.class);
    private Schema reportInputSchema;
    private final Processor processor;
    private final URI repository;
    private final URIResolver resolver;
    private final UnparsedTextURIResolver unparsedTextURIResolver;
    private final SchemaFactory schemaFactory;
    private final ResolvingConfigurationStrategy resolvingConfigurationStrategy;

    public ContentRepository(ResolvingConfigurationStrategy strategy, URI repository) {
        this.repository = repository;
        this.resolvingConfigurationStrategy = strategy;
        this.processor = this.resolvingConfigurationStrategy.getProcessor();
        this.resolver = this.resolvingConfigurationStrategy.createResolver(repository);
        this.unparsedTextURIResolver = this.resolvingConfigurationStrategy.createUnparsedTextURIResolver(repository);
        this.schemaFactory = this.resolvingConfigurationStrategy.createSchemaFactory();
    }

    private static Source resolve(URL resource) {
        try {
            return new StreamSource(resource.openStream(), resource.toURI().getRawPath());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Can not load schema for resource " + resource.getPath(), e);
        }
    }

    private Schema createSchema(Source[] schemaSources, LSResourceResolver resourceResolver) {
        try {
            SchemaFactory sf = this.schemaFactory;
            sf.setResourceResolver(resourceResolver);
            return sf.newSchema(schemaSources);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Can not load schema from sources " + schemaSources[0].getSystemId(), e);
        }
    }

    private Schema createSchema(Source[] schemaSources) {
        return this.createSchema(schemaSources, null);
    }

    public XsltExecutable loadXsltScript(URI uri) {
        log.info("Loading XSLT script from  {}", (Object)uri);
        XsltCompiler xsltCompiler = this.getProcessor().newXsltCompiler();
        CollectingErrorEventHandler listener = new CollectingErrorEventHandler();
        try {
            xsltCompiler.setErrorListener((ErrorListener)listener);
            if (this.getResolver() != null) {
                xsltCompiler.setURIResolver(this.getResolver());
            }
            XsltExecutable xsltExecutable = xsltCompiler.compile(this.resolveInRepository(uri));
            return xsltExecutable;
        }
        catch (SaxonApiException e2) {
            listener.getErrors().forEach(event -> event.log(log));
            throw new IllegalStateException("Can not compile xslt executable for uri " + uri, e2);
        }
        finally {
            if (!listener.hasErrors() && listener.hasEvents()) {
                log.warn("Received warnings or errors while loading a xslt script {}", (Object)uri);
                listener.getErrors().forEach(e -> e.log(log));
            }
        }
    }

    public Schema createSchema(URL url) {
        return this.createSchema(url, null);
    }

    public Schema createSchema(URI uri) {
        return this.createSchema(new Source[]{this.resolveInRepository(uri)});
    }

    public Schema createSchema(URL url, LSResourceResolver resourceResolver) {
        log.info("Load schema from source {}", (Object)url.getPath());
        return this.createSchema(new Source[]{ContentRepository.resolve(url)}, resourceResolver);
    }

    public Schema getScenarioSchema() {
        return this.createSchema(ContentRepository.class.getResource("/xsd/scenarios.xsd"));
    }

    public Schema getReportInputSchema() {
        if (this.reportInputSchema == null) {
            Source source = ContentRepository.resolve(ContentRepository.class.getResource("/xsd/createReportInput.xsd"));
            this.reportInputSchema = this.createSchema(new Source[]{source}, (LSResourceResolver)new ClassPathResourceResolver("/xsd"));
        }
        return this.reportInputSchema;
    }

    public Schema createSchema(Collection<String> uris) {
        return this.createSchema((Source[])uris.stream().map(s -> this.resolveInRepository(URI.create(s))).toArray(Source[]::new));
    }

    public Schema createSchema(ScenarioType s) {
        Schema schema = null;
        if (s.getValidateWithXmlSchema() != null) {
            List<String> schemaResources = s.getValidateWithXmlSchema().getResource().stream().map(ResourceType::getLocation).collect(Collectors.toList());
            schema = this.createSchema(schemaResources);
        }
        return schema;
    }

    private Source resolveInRepository(URI source) {
        try {
            if (this.resolver == null) {
                URI resolved = RelativeUriResolver.resolve(source, this.repository);
                return new StreamSource(resolved.toASCIIString());
            }
            return this.resolver.resolve(source.toString(), this.repository.toString());
        }
        catch (TransformerException e) {
            log.error("Error resolving source {}", (Object)source, (Object)e);
            throw new IllegalStateException(String.format("Can not resolve %s in repository %s", source, this.repository), e);
        }
    }

    public XPathExecutable createXPath(String expression, Map<String, String> namespaces) {
        try {
            XPathCompiler compiler = this.getProcessor().newXPathCompiler();
            if (namespaces != null) {
                namespaces.forEach((arg_0, arg_1) -> ((XPathCompiler)compiler).declareNamespace(arg_0, arg_1));
            }
            return compiler.compile(expression);
        }
        catch (SaxonApiException e) {
            throw new IllegalStateException(String.format("Can not compile xpath match expression '%s'", StringUtils.isNotBlank((CharSequence)expression) ? expression : "EMPTY EXPRESSION"), e);
        }
    }

    public URIResolver getResolver() {
        return this.resolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextURIResolver;
    }

    public Scenario.Transformation createReportTransformation(ScenarioType t) {
        ResourceType resource = t.getCreateReport().getResource();
        return this.createTransformation(resource);
    }

    public Scenario.Transformation createTransformation(ResourceType resource) {
        XsltExecutable executable = this.loadXsltScript(URI.create(resource.getLocation()));
        return new Scenario.Transformation(executable, resource);
    }

    public XPathExecutable createMatchExecutable(ScenarioType s) {
        Map<String, String> namespaces = s.getNamespace().stream().collect(Collectors.toMap(NamespaceType::getPrefix, ns -> StringTrimAdapter.trim(ns.getValue())));
        return this.createXPath(s.getMatch(), namespaces);
    }

    public XPathExecutable createAccepptExecutable(ScenarioType s) {
        Map<String, String> namespaces = s.getNamespace().stream().collect(Collectors.toMap(NamespaceType::getPrefix, ns -> StringTrimAdapter.trim(ns.getValue())));
        return this.createXPath(s.getAcceptMatch(), namespaces);
    }

    public List<Scenario.Transformation> createSchematronTransformations(ScenarioType s) {
        return s.getValidateWithSchematron().isEmpty() ? Collections.emptyList() : s.getValidateWithSchematron().stream().map(this::createSchematronTransformation).collect(Collectors.toList());
    }

    public Scenario.Transformation createSchematronTransformation(ValidateWithSchematron validateWithSchematron) {
        return this.createTransformation(validateWithSchematron.getResource());
    }

    public ContentRepository(Processor processor, URI repository, URIResolver resolver, UnparsedTextURIResolver unparsedTextURIResolver, SchemaFactory schemaFactory, ResolvingConfigurationStrategy resolvingConfigurationStrategy) {
        this.processor = processor;
        this.repository = repository;
        this.resolver = resolver;
        this.unparsedTextURIResolver = unparsedTextURIResolver;
        this.schemaFactory = schemaFactory;
        this.resolvingConfigurationStrategy = resolvingConfigurationStrategy;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public ResolvingConfigurationStrategy getResolvingConfigurationStrategy() {
        return this.resolvingConfigurationStrategy;
    }
}

